/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qi4j.api.common.Optional;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.runtime.composite.AbstractConstraintModel;
import org.qi4j.runtime.composite.ConstraintInstance;

public final class ValueConstraintsInstance {
    private static final Optional OPTIONAL = new OptionalDummy();
    private final List<ConstraintInstance> constraints;
    private String name;
    private boolean optional;

    public ValueConstraintsInstance(List<AbstractConstraintModel> constraintModels, String name, boolean optional) {
        this.name = name;
        this.optional = optional;
        this.constraints = new ArrayList<ConstraintInstance>();
        for (AbstractConstraintModel constraintModel : constraintModels) {
            this.constraints.add(constraintModel.newInstance());
        }
    }

    public List<ConstraintViolation> checkConstraints(Object value) {
        List<ConstraintViolation> violations = null;
        if (this.optional) {
            if (value == null) {
                violations = Collections.emptyList();
            }
        } else if (value == null) {
            violations = new ArrayList();
            violations.add(new ConstraintViolation(this.name, (Annotation)OPTIONAL, null));
        }
        if (violations == null && value != null) {
            for (ConstraintInstance constraint : this.constraints) {
                boolean valid;
                try {
                    valid = constraint.isValid(value);
                }
                catch (NullPointerException e) {
                    valid = false;
                }
                if (valid) continue;
                if (violations == null) {
                    violations = new ArrayList<ConstraintViolation>();
                }
                ConstraintViolation violation = new ConstraintViolation(this.name, constraint.annotation(), value);
                violations.add(violation);
            }
        }
        if (violations == null) {
            violations = Collections.emptyList();
        }
        return violations;
    }

    private static class OptionalDummy
    implements Optional {
        private OptionalDummy() {
        }

        public Class<? extends Annotation> annotationType() {
            return Optional.class;
        }

        public String toString() {
            return "not optional";
        }
    }
}

