/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.entity;

import java.lang.reflect.Method;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.entity.Queryable;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.EntityCompositeAlreadyExistsException;
import org.qi4j.api.util.Annotations;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.runtime.composite.CompositeMethodsModel;
import org.qi4j.runtime.composite.CompositeModel;
import org.qi4j.runtime.entity.EntityInstance;
import org.qi4j.runtime.entity.EntityMixinsModel;
import org.qi4j.runtime.entity.EntityStateInstance;
import org.qi4j.runtime.entity.EntityStateModel;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entitystore.EntityAlreadyExistsException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.module.ModuleSpi;

public final class EntityModel
extends CompositeModel
implements EntityDescriptor {
    private static final Method IDENTITY_METHOD;
    private final boolean queryable;

    public EntityModel(Iterable<Class<?>> types, Visibility visibility, MetaInfo info, EntityMixinsModel mixinsModel, EntityStateModel stateModel, CompositeMethodsModel compositeMethodsModel) {
        super(types, visibility, info, mixinsModel, stateModel, compositeMethodsModel);
        Queryable queryable = (Queryable)Iterables.first((Iterable)Iterables.cast((Iterable)Iterables.filter((Specification)Annotations.isType(Queryable.class), (Iterable)Iterables.flattenIterables((Iterable)Iterables.map((Function)Annotations.ANNOTATIONS_OF, types)))));
        this.queryable = queryable == null || queryable.value();
    }

    public boolean queryable() {
        return this.queryable;
    }

    @Override
    public EntityStateModel state() {
        return (EntityStateModel)super.state();
    }

    public EntityInstance newInstance(ModuleUnitOfWork uow, ModuleSpi moduleInstance, EntityState state) {
        EntityInstance instance = new EntityInstance(uow, moduleInstance, this, state);
        return instance;
    }

    public Object[] newMixinHolder() {
        return this.mixinsModel.newMixinHolder();
    }

    public Object newMixin(Object[] mixins, EntityStateInstance entityState, EntityInstance entityInstance, Method method) {
        return ((EntityMixinsModel)this.mixinsModel).newMixin(entityInstance, (StateHolder)entityState, mixins, method);
    }

    public EntityState newEntityState(EntityStoreUnitOfWork store, ModuleSpi module, EntityReference identity) throws ConstraintViolationException, EntityStoreException {
        try {
            EntityState entityState = store.newEntityState(module, identity, (EntityDescriptor)this);
            PropertyModel persistentPropertyDescriptor = this.state().propertyModelFor(IDENTITY_METHOD);
            entityState.setPropertyValue(persistentPropertyDescriptor.qualifiedName(), (Object)identity.identity());
            return entityState;
        }
        catch (EntityAlreadyExistsException e) {
            throw new EntityCompositeAlreadyExistsException(identity);
        }
        catch (EntityStoreException e) {
            throw new ConstructionException("Could not create new entity in store", (Throwable)e);
        }
    }

    public void initState(ModuleSpi module, EntityState entityState) {
        for (PropertyModel propertyModel : this.state().properties()) {
            entityState.setPropertyValue(propertyModel.qualifiedName(), propertyModel.initialValue((Module)module));
        }
        for (AssociationDescriptor associationDescriptor : this.state().associations()) {
            entityState.setAssociationValue(associationDescriptor.qualifiedName(), null);
        }
        for (AssociationDescriptor associationDescriptor : this.state().manyAssociations()) {
            entityState.manyAssociationValueOf(associationDescriptor.qualifiedName());
        }
        for (AssociationDescriptor associationDescriptor : this.state().namedAssociations()) {
            entityState.namedAssociationValueOf(associationDescriptor.qualifiedName());
        }
    }

    public void invokeLifecycle(boolean create, Object[] mixins, CompositeInstance instance, StateHolder state) {
        ((EntityMixinsModel)this.mixinsModel).invokeLifecycle(create, mixins, instance, state);
    }

    static {
        try {
            IDENTITY_METHOD = Identity.class.getMethod("identity", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Zest Core Runtime codebase is corrupted. Contact Zest team: ModuleUnitOfWork");
        }
    }
}

