/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.entity;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.association.AssociationInstance;
import org.qi4j.runtime.association.AssociationModel;
import org.qi4j.runtime.association.ManyAssociationInstance;
import org.qi4j.runtime.association.ManyAssociationModel;
import org.qi4j.runtime.association.NamedAssociationInstance;
import org.qi4j.runtime.association.NamedAssociationModel;
import org.qi4j.runtime.composite.ConstraintsCheck;
import org.qi4j.runtime.entity.EntityPropertyInstance;
import org.qi4j.runtime.entity.EntityStateModel;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.unitofwork.BuilderEntityState;
import org.qi4j.spi.entity.EntityState;

public final class EntityStateInstance
implements AssociationStateHolder {
    private Map<AccessibleObject, Object> state;
    private final EntityStateModel stateModel;
    private EntityState entityState;
    private final Function2<EntityReference, Type, Object> entityFunction;

    public EntityStateInstance(EntityStateModel stateModel, final UnitOfWork uow, EntityState entityState) {
        this.stateModel = stateModel;
        this.entityState = entityState;
        this.entityFunction = new Function2<EntityReference, Type, Object>(){

            public Object map(EntityReference entityReference, Type type) {
                return uow.get((Class)Classes.RAW_CLASS.map((Object)type), entityReference.identity());
            }
        };
    }

    public <T> Property<T> propertyFor(AccessibleObject accessor) throws IllegalArgumentException {
        Map<AccessibleObject, Object> state = this.state();
        EntityPropertyInstance property = (EntityPropertyInstance)state.get(accessor);
        if (property == null) {
            PropertyModel entityPropertyModel = this.stateModel.propertyModelFor(accessor);
            property = new EntityPropertyInstance(this.entityState instanceof BuilderEntityState ? entityPropertyModel.getBuilderInfo() : entityPropertyModel, this.entityState);
            state.put(accessor, property);
        }
        return property;
    }

    public Iterable<Property<?>> properties() {
        return Iterables.map((Function)new Function<PropertyDescriptor, Property<?>>(){

            public Property<?> map(PropertyDescriptor propertyDescriptor) {
                return EntityStateInstance.this.propertyFor(propertyDescriptor.accessor());
            }
        }, this.stateModel.properties());
    }

    public <T> Association<T> associationFor(AccessibleObject accessor) throws IllegalArgumentException {
        Map<AccessibleObject, Object> state = this.state();
        AssociationInstance association = (AssociationInstance)state.get(accessor);
        if (association == null) {
            final AssociationModel associationModel = this.stateModel.getAssociation(accessor);
            association = new AssociationInstance(this.entityState instanceof BuilderEntityState ? associationModel.getBuilderInfo() : associationModel, this.entityFunction, new Property<EntityReference>(){

                public EntityReference get() {
                    return EntityStateInstance.this.entityState.associationValueOf(associationModel.qualifiedName());
                }

                public void set(EntityReference newValue) throws IllegalArgumentException, IllegalStateException {
                    EntityStateInstance.this.entityState.setAssociationValue(associationModel.qualifiedName(), newValue);
                }
            });
            state.put(accessor, association);
        }
        return association;
    }

    public Iterable<Association<?>> allAssociations() {
        return Iterables.map((Function)new Function<AssociationDescriptor, Association<?>>(){

            public Association<?> map(AssociationDescriptor associationDescriptor) {
                return EntityStateInstance.this.associationFor(associationDescriptor.accessor());
            }
        }, this.stateModel.associations());
    }

    public <T> ManyAssociation<T> manyAssociationFor(AccessibleObject accessor) {
        Map<AccessibleObject, Object> state = this.state();
        ManyAssociationInstance manyAssociation = (ManyAssociationInstance)state.get(accessor);
        if (manyAssociation == null) {
            ManyAssociationModel associationModel = this.stateModel.getManyAssociation(accessor);
            manyAssociation = new ManyAssociationInstance(this.entityState instanceof BuilderEntityState ? associationModel.getBuilderInfo() : associationModel, this.entityFunction, this.entityState.manyAssociationValueOf(associationModel.qualifiedName()));
            state.put(accessor, manyAssociation);
        }
        return manyAssociation;
    }

    public Iterable<ManyAssociation<?>> allManyAssociations() {
        return Iterables.map((Function)new Function<AssociationDescriptor, ManyAssociation<?>>(){

            public ManyAssociation<?> map(AssociationDescriptor associationDescriptor) {
                return EntityStateInstance.this.manyAssociationFor(associationDescriptor.accessor());
            }
        }, this.stateModel.manyAssociations());
    }

    public <T> NamedAssociation<T> namedAssociationFor(AccessibleObject accessor) {
        Map<AccessibleObject, Object> state = this.state();
        NamedAssociationInstance namedAssociation = (NamedAssociationInstance)state.get(accessor);
        if (namedAssociation == null) {
            NamedAssociationModel associationModel = this.stateModel.getNamedAssociation(accessor);
            namedAssociation = new NamedAssociationInstance(this.entityState instanceof BuilderEntityState ? associationModel.getBuilderInfo() : associationModel, this.entityFunction, this.entityState.namedAssociationValueOf(associationModel.qualifiedName()));
            state.put(accessor, namedAssociation);
        }
        return namedAssociation;
    }

    public Iterable<? extends NamedAssociation<?>> allNamedAssociations() {
        return Iterables.map((Function)new Function<AssociationDescriptor, NamedAssociation<?>>(){

            public NamedAssociation<?> map(AssociationDescriptor associationDescriptor) {
                return EntityStateInstance.this.namedAssociationFor(associationDescriptor.accessor());
            }
        }, this.stateModel.namedAssociations());
    }

    public void checkConstraints() {
        ConstraintsCheck constraints;
        for (PropertyDescriptor propertyDescriptor : this.stateModel.properties()) {
            constraints = (ConstraintsCheck)propertyDescriptor;
            Property property = this.propertyFor(propertyDescriptor.accessor());
            constraints.checkConstraints(property.get());
        }
        for (AssociationDescriptor associationDescriptor : this.stateModel.associations()) {
            constraints = (ConstraintsCheck)associationDescriptor;
            Association association = this.associationFor(associationDescriptor.accessor());
            constraints.checkConstraints(association.get());
        }
    }

    private Map<AccessibleObject, Object> state() {
        if (this.state == null) {
            this.state = new HashMap<AccessibleObject, Object>();
        }
        return this.state;
    }
}

