/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.common.Optional;
import org.qi4j.api.composite.DependencyDescriptor;
import org.qi4j.api.util.Annotations;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Visitable;
import org.qi4j.functional.Visitor;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderException;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;

public final class DependencyModel
implements Binder,
DependencyDescriptor,
Visitable<DependencyModel> {
    private final Annotation injectionAnnotation;
    private final Type injectionType;
    private final Class<?> injectedClass;
    private final Class<?> rawInjectionClass;
    private final boolean optional;
    private final Annotation[] annotations;
    private InjectionProvider injectionProvider;
    private static final Class<?>[] primitiveTypeMapping = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Character.TYPE, Character.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class};

    public static boolean isOptional(Annotation injectionAnnotation, Annotation[] annotations) {
        Method[] methods;
        if (Iterables.matchesAny((Specification)Annotations.isType(Optional.class), (Iterable)Iterables.iterable((Object[])annotations))) {
            return true;
        }
        for (Method method : methods = injectionAnnotation.annotationType().getMethods()) {
            if (!method.getName().equals("optional")) continue;
            try {
                return (Boolean)method.invoke((Object)injectionAnnotation, new Object[0]);
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public DependencyModel(Annotation injectionAnnotation, Type genericType, Class<?> injectedClass, boolean optional, Annotation[] annotations) {
        this.injectionAnnotation = injectionAnnotation;
        this.injectedClass = injectedClass;
        this.injectionType = genericType;
        this.optional = optional;
        this.annotations = annotations;
        this.rawInjectionClass = this.mapPrimitiveTypes(this.extractRawInjectionClass(injectedClass, this.injectionType));
    }

    public <ThrowableType extends Throwable> boolean accept(Visitor<? super DependencyModel, ThrowableType> visitor) throws ThrowableType {
        return visitor.visit((Object)this);
    }

    private Class<?> extractRawInjectionClass(Class<?> injectedClass, Type injectionType) {
        if (injectionType instanceof Class) {
            return (Class)injectionType;
        }
        if (injectionType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)injectionType).getRawType();
        }
        if (injectionType instanceof TypeVariable) {
            return this.extractRawInjectionClass(injectedClass, (TypeVariable)injectionType);
        }
        throw new IllegalArgumentException("Could not extract the rawInjectionClass of " + injectedClass + " and " + injectionType);
    }

    private Class<?> extractRawInjectionClass(Class<?> injectedClass, TypeVariable<?> injectionTypeVariable) {
        int index = 0;
        for (TypeVariable<?> typeVariable : injectionTypeVariable.getGenericDeclaration().getTypeParameters()) {
            if (injectionTypeVariable.getName().equals(typeVariable.getName())) {
                return (Class)this.getActualType(injectedClass, index);
            }
            ++index;
        }
        throw new IllegalArgumentException("Could not extract the rawInjectionClass of " + injectedClass + " and " + injectionTypeVariable);
    }

    private Type getActualType(Class<?> injectedClass, int index) {
        Type genericType = injectedClass;
        Object type = null;
        while (!Object.class.equals(genericType) && type == null) {
            if ((genericType = ((Class)genericType).getGenericSuperclass()) instanceof ParameterizedType) {
                type = ((ParameterizedType)genericType).getActualTypeArguments()[index];
                continue;
            }
            Type[] genericInterfaces = ((Class)genericType).getGenericInterfaces();
            if (genericInterfaces.length <= index || !((type = genericInterfaces[index]) instanceof ParameterizedType)) continue;
            type = ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        if (type == null) {
            type = Object.class;
        }
        return type;
    }

    private Type extractDependencyType(Type injectionType) {
        if (injectionType instanceof ParameterizedType) {
            return ((ParameterizedType)injectionType).getActualTypeArguments()[0];
        }
        if (injectionType instanceof TypeVariable) {
            return ((TypeVariable)injectionType).getBounds()[0];
        }
        return injectionType;
    }

    public Annotation injectionAnnotation() {
        return this.injectionAnnotation;
    }

    public Type injectionType() {
        return this.injectionType;
    }

    public Class<?> injectedClass() {
        return this.injectedClass;
    }

    public Class<?> rawInjectionType() {
        return this.rawInjectionClass;
    }

    public boolean optional() {
        return this.optional;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    @Override
    public void bind(Resolution resolution) throws BindingException {
        InjectionProviderFactory providerFactory = resolution.application().injectionProviderFactory();
        try {
            this.injectionProvider = providerFactory.newInjectionProvider(resolution, this);
            if (this.injectionProvider == null && !this.optional) {
                String message = "[Module " + resolution.module().name() + "] Non-optional @" + this.rawInjectionClass.getName() + " was not bound in " + this.injectedClass.getName();
                throw new ConstructionException(message);
            }
        }
        catch (InvalidInjectionException e) {
            throw new BindingException("Could not bind dependency injection", e);
        }
    }

    public Object inject(InjectionContext context) {
        Object injectedValue;
        if (this.injectionProvider == null) {
            return null;
        }
        try {
            injectedValue = this.injectionProvider.provideInjection(context);
        }
        catch (InjectionProviderException e) {
            Throwable ex = e;
            if (ex.getCause() != null) {
                ex = ex.getCause();
            }
            String message = "[Module " + context.module().name() + "] InjectionProvider unable to resolve @" + this.injectionAnnotation.annotationType().getSimpleName() + " " + this.injectionType.toString();
            throw new ConstructionException(message, ex);
        }
        if (injectedValue == null && !this.optional) {
            String simpleName = this.injectionAnnotation.annotationType().getSimpleName();
            String message = "[Module " + context.module().name() + "] Non-optional @" + simpleName + " " + this.injectionType.toString() + " was null in " + this.injectedClass.getName();
            if (simpleName.toLowerCase().contains("service")) {
                message = message + ". Did you mean the @Service injection scope?";
            }
            throw new ConstructionException(message);
        }
        return this.getInjectedValue(injectedValue);
    }

    private Object getInjectedValue(Object injectionResult) {
        if (injectionResult == null) {
            return null;
        }
        if (injectionResult instanceof Iterable) {
            if (Iterable.class.isAssignableFrom(this.rawInjectionClass) || this.rawInjectionClass.isInstance(injectionResult)) {
                return injectionResult;
            }
            return Iterables.first((Iterable)((Iterable)injectionResult));
        }
        if (Iterable.class.equals((Object)this.injectionType)) {
            return Collections.singleton(injectionResult);
        }
        return injectionResult;
    }

    private Class<?> mapPrimitiveTypes(Class<?> rawInjectionType) {
        if (rawInjectionType == null || !rawInjectionType.isPrimitive()) {
            return rawInjectionType;
        }
        for (int i = 0; i < primitiveTypeMapping.length; i += 2) {
            if (!primitiveTypeMapping[i].equals(rawInjectionType)) continue;
            return primitiveTypeMapping[i + 1];
        }
        return rawInjectionType;
    }

    public boolean hasScope(Class<? extends Annotation> scope) {
        return scope == null || scope.equals(this.injectionAnnotation().annotationType());
    }

    public Class<? extends Annotation> injectionAnnotationType() {
        if (this.injectionAnnotation == null) {
            return null;
        }
        return this.injectionAnnotation.annotationType();
    }

    public String toString() {
        return this.injectionAnnotation + " for " + this.injectionType + " in " + this.injectedClass.getName();
    }

    public static class InjectionTypeFunction
    implements Function<DependencyModel, Class<?>> {
        public Class<?> map(DependencyModel dependencyModel) {
            return dependencyModel.rawInjectionType();
        }
    }

    public static class ScopeSpecification
    implements Specification<DependencyModel> {
        private final Class<? extends Annotation> scope;

        public ScopeSpecification(Class<? extends Annotation> scope) {
            this.scope = scope;
        }

        public boolean satisfiedBy(DependencyModel model) {
            return model.hasScope(this.scope);
        }
    }
}

