/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import org.qi4j.api.composite.InjectedFieldDescriptor;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.bootstrap.InjectionException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Specification;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.TransientInstance;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.model.Resolution;

public final class InjectedFieldModel
implements InjectedFieldDescriptor,
VisitableHierarchy<InjectedFieldModel, DependencyModel> {
    private DependencyModel dependencyModel;
    private Field injectedField;

    public InjectedFieldModel(Field injectedField, DependencyModel dependencyModel) {
        injectedField.setAccessible(true);
        this.injectedField = injectedField;
        this.dependencyModel = dependencyModel;
    }

    public DependencyModel dependency() {
        return this.dependencyModel;
    }

    public Field field() {
        return this.injectedField;
    }

    public void bind(Resolution resolution) throws BindingException {
        this.dependencyModel.bind(resolution.forField(this.injectedField));
    }

    public void inject(InjectionContext context, Object instance) {
        Object value = this.dependencyModel.inject(context);
        try {
            this.injectedField.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String valueClassName;
            if (Proxy.isProxyClass(value.getClass())) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(value);
                if (invocationHandler instanceof TransientInstance) {
                    TransientInstance handler = (TransientInstance)((Object)invocationHandler);
                    valueClassName = Classes.toString(handler.descriptor().types()) + " in [" + handler.module().name() + "] of [" + handler.layer().name() + "]";
                } else {
                    valueClassName = invocationHandler.toString();
                }
            } else {
                valueClassName = value.getClass().getName();
            }
            StringBuilder annotBuilder = new StringBuilder();
            for (Annotation annot : this.injectedField.getAnnotations()) {
                String s = annot.toString();
                annotBuilder.append("@").append(s.substring(s.lastIndexOf(46) + 1, s.length() - 2));
                annotBuilder.append(" ");
            }
            String annots = annotBuilder.toString();
            String message = "Can not inject the field\n    " + this.injectedField.getDeclaringClass() + "\n    {\n        " + annots + "\n        " + this.injectedField.getType().getSimpleName() + " " + this.injectedField.getName() + "\n    }\nwith value \n    " + value + "\nof type\n    " + valueClassName;
            throw new InjectionException(message, (Throwable)e);
        }
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super InjectedFieldModel, ? super DependencyModel, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this)) {
            visitor.visit((Object)this.dependencyModel);
        }
        return visitor.visitLeave((Object)this);
    }

    public Collection<DependencyModel> filter(Specification<DependencyModel> specification) {
        if (specification.satisfiedBy((Object)this.dependencyModel)) {
            return Collections.singleton(this.dependencyModel);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "InjectedFieldModel{, injectedField=" + this.injectedField + '}';
    }
}

