/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection.provider;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.composite.InvalidValueCompositeException;
import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.api.concern.internal.ConcernFor;
import org.qi4j.api.injection.scope.Invocation;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.State;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.sideeffect.internal.SideEffectFor;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.CachingInjectionProviderFactoryDecorator;
import org.qi4j.runtime.injection.provider.InvocationInjectionProviderFactory;
import org.qi4j.runtime.injection.provider.ModifiesInjectionProviderFactory;
import org.qi4j.runtime.injection.provider.ServiceInjectionProviderFactory;
import org.qi4j.runtime.injection.provider.StateInjectionProviderFactory;
import org.qi4j.runtime.injection.provider.StructureInjectionProviderFactory;
import org.qi4j.runtime.injection.provider.ThisInjectionProviderFactory;
import org.qi4j.runtime.injection.provider.UsesInjectionProviderFactory;
import org.qi4j.runtime.model.Resolution;

public final class InjectionProviderFactoryStrategy
implements InjectionProviderFactory {
    private final Map<Class<? extends Annotation>, InjectionProviderFactory> generalProviderFactories = new HashMap<Class<? extends Annotation>, InjectionProviderFactory>();
    private final Map<Class<? extends Annotation>, InjectionProviderFactory> valuesProviderFactories = new HashMap<Class<? extends Annotation>, InjectionProviderFactory>();
    private MetaInfo metaInfo;

    public InjectionProviderFactoryStrategy(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.valuesProviderFactories.put(This.class, new ThisInjectionProviderFactory());
        ModifiesInjectionProviderFactory modifiesInjectionProviderFactory = new ModifiesInjectionProviderFactory();
        this.valuesProviderFactories.put(ConcernFor.class, modifiesInjectionProviderFactory);
        this.valuesProviderFactories.put(SideEffectFor.class, modifiesInjectionProviderFactory);
        this.valuesProviderFactories.put(State.class, new StateInjectionProviderFactory());
        this.valuesProviderFactories.put(Structure.class, new CachingInjectionProviderFactoryDecorator(new StructureInjectionProviderFactory()));
        this.valuesProviderFactories.put(Service.class, new CachingInjectionProviderFactoryDecorator(new ServiceInjectionProviderFactory()));
        this.generalProviderFactories.put(Invocation.class, new InvocationInjectionProviderFactory());
        this.generalProviderFactories.put(Uses.class, new UsesInjectionProviderFactory());
    }

    @Override
    public InjectionProvider newInjectionProvider(Resolution resolution, DependencyModel dependencyModel) throws InvalidInjectionException {
        Class<? extends Annotation> injectionAnnotationType = dependencyModel.injectionAnnotation().annotationType();
        InjectionProviderFactory factory1 = this.generalProviderFactories.get(injectionAnnotationType);
        InjectionProviderFactory factory2 = this.valuesProviderFactories.get(injectionAnnotationType);
        if (factory1 == null && factory2 == null) {
            InjectionProviderFactory factory = (InjectionProviderFactory)this.metaInfo.get(InjectionProviderFactory.class);
            if (factory != null) {
                return factory.newInjectionProvider(resolution, dependencyModel);
            }
            throw new InvalidInjectionException("Unknown injection annotation @" + injectionAnnotationType.getSimpleName());
        }
        ModelDescriptor composite = resolution.model();
        Class compositeType = (Class)Iterables.first((Iterable)composite.types());
        if (factory1 != null && ValueComposite.class.isAssignableFrom(compositeType)) {
            throw new InvalidValueCompositeException("@" + injectionAnnotationType.getSimpleName() + " is not allowed in ValueComposites: " + compositeType);
        }
        InjectionProviderFactory factory = factory1 == null ? factory2 : factory1;
        return factory.newInjectionProvider(resolution, dependencyModel);
    }
}

