/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection.provider;

import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.composite.StateDescriptor;
import org.qi4j.api.composite.StatefulCompositeDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.injection.scope.State;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.runtime.entity.EntityInstance;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderException;
import org.qi4j.runtime.model.Resolution;

public final class StateInjectionProviderFactory
implements InjectionProviderFactory {
    @Override
    public InjectionProvider newInjectionProvider(Resolution resolution, DependencyModel dependencyModel) throws InvalidInjectionException {
        if (StateHolder.class.isAssignableFrom(dependencyModel.rawInjectionType())) {
            return new StateInjectionProvider();
        }
        if (UnitOfWork.class.isAssignableFrom(dependencyModel.rawInjectionType())) {
            if (!(resolution.model() instanceof EntityDescriptor)) {
                throw new InvalidInjectionException("Only EntityComposites can be injected with '@State UnitOfWork'");
            }
            return new UnitOfWorkInjectionProvider();
        }
        if (Property.class.isAssignableFrom(dependencyModel.rawInjectionType())) {
            StateDescriptor descriptor = ((StatefulCompositeDescriptor)resolution.model()).state();
            State annotation = (State)dependencyModel.injectionAnnotation();
            String name = annotation.value().isEmpty() ? resolution.field().getName() : annotation.value();
            PropertyDescriptor propertyDescriptor = descriptor.findPropertyModelByName(name);
            return new PropertyInjectionProvider(propertyDescriptor);
        }
        if (Association.class.isAssignableFrom(dependencyModel.rawInjectionType())) {
            AssociationStateDescriptor descriptor = ((EntityDescriptor)resolution.model()).state();
            State annotation = (State)dependencyModel.injectionAnnotation();
            String name = annotation.value().isEmpty() ? resolution.field().getName() : annotation.value();
            AssociationDescriptor model = descriptor.getAssociationByName(name);
            return new AssociationInjectionProvider(model);
        }
        if (ManyAssociation.class.isAssignableFrom(dependencyModel.rawInjectionType())) {
            AssociationStateDescriptor descriptor = ((EntityDescriptor)resolution.model()).state();
            State annotation = (State)dependencyModel.injectionAnnotation();
            String name = annotation.value().isEmpty() ? resolution.field().getName() : annotation.value();
            AssociationDescriptor model = descriptor.getManyAssociationByName(name);
            return new ManyAssociationInjectionProvider(model);
        }
        if (NamedAssociation.class.isAssignableFrom(dependencyModel.rawInjectionType())) {
            AssociationStateDescriptor descriptor = ((EntityDescriptor)resolution.model()).state();
            State annotation = (State)dependencyModel.injectionAnnotation();
            String name = annotation.value().isEmpty() ? resolution.field().getName() : annotation.value();
            AssociationDescriptor model = descriptor.getNamedAssociationByName(name);
            return new NamedAssociationInjectionProvider(model);
        }
        throw new InjectionProviderException("Injected value has invalid type");
    }

    private static class UnitOfWorkInjectionProvider
    implements InjectionProvider {
        private UnitOfWorkInjectionProvider() {
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            return ((EntityInstance)context.compositeInstance()).unitOfWork();
        }
    }

    private static class StateInjectionProvider
    implements InjectionProvider {
        private StateInjectionProvider() {
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            return context.state();
        }
    }

    private static class NamedAssociationInjectionProvider
    implements InjectionProvider {
        private final AssociationDescriptor namedAssociationDescriptor;

        private NamedAssociationInjectionProvider(AssociationDescriptor namedAssociationDescriptor) {
            this.namedAssociationDescriptor = namedAssociationDescriptor;
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            NamedAssociation abstractAssociation = ((AssociationStateHolder)context.state()).namedAssociationFor(this.namedAssociationDescriptor.accessor());
            if (abstractAssociation != null) {
                return abstractAssociation;
            }
            throw new InjectionProviderException("Non-optional association " + this.namedAssociationDescriptor.qualifiedName() + " had no association");
        }
    }

    private static class ManyAssociationInjectionProvider
    implements InjectionProvider {
        private final AssociationDescriptor manyAssociationDescriptor;

        private ManyAssociationInjectionProvider(AssociationDescriptor manyAssociationDescriptor) {
            this.manyAssociationDescriptor = manyAssociationDescriptor;
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            ManyAssociation abstractAssociation = ((AssociationStateHolder)context.state()).manyAssociationFor(this.manyAssociationDescriptor.accessor());
            if (abstractAssociation != null) {
                return abstractAssociation;
            }
            throw new InjectionProviderException("Non-optional association " + this.manyAssociationDescriptor.qualifiedName() + " had no association");
        }
    }

    private static class AssociationInjectionProvider
    implements InjectionProvider {
        private final AssociationDescriptor associationDescriptor;

        private AssociationInjectionProvider(AssociationDescriptor associationDescriptor) {
            this.associationDescriptor = associationDescriptor;
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            Association abstractAssociation = ((AssociationStateHolder)context.state()).associationFor(this.associationDescriptor.accessor());
            if (abstractAssociation != null) {
                return abstractAssociation;
            }
            throw new InjectionProviderException("Non-optional association " + this.associationDescriptor.qualifiedName() + " had no association");
        }
    }

    private static class PropertyInjectionProvider
    implements InjectionProvider {
        private final PropertyDescriptor propertyDescriptor;

        private PropertyInjectionProvider(PropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            Property value = context.state().propertyFor(this.propertyDescriptor.accessor());
            if (value != null) {
                return value;
            }
            throw new InjectionProviderException("Non-optional property " + this.propertyDescriptor + " had no value");
        }
    }
}

