/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection.provider;

import java.lang.reflect.Type;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.TransientBuilderFactory;
import org.qi4j.api.object.ObjectFactory;
import org.qi4j.api.query.QueryBuilderFactory;
import org.qi4j.api.service.ServiceFinder;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Layer;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderException;
import org.qi4j.runtime.model.Resolution;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.spi.module.ModuleSpi;

public final class StructureInjectionProviderFactory
implements InjectionProviderFactory {
    @Override
    public InjectionProvider newInjectionProvider(Resolution resolution, DependencyModel dependencyModel) throws InvalidInjectionException {
        return new StructureInjectionProvider(dependencyModel);
    }

    private static class StructureInjectionProvider
    implements InjectionProvider {
        private final DependencyModel dependencyModel;

        private StructureInjectionProvider(DependencyModel dependencyModel) {
            this.dependencyModel = dependencyModel;
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            Type type1 = this.dependencyModel.injectionType();
            if (!(type1 instanceof Class)) {
                throw new InjectionProviderException("Type [" + type1 + "] can not be injected from the @Structure injection scope: " + context);
            }
            Class clazz = (Class)type1;
            if (clazz.equals(TransientBuilderFactory.class)) {
                return context.module();
            }
            if (clazz.equals(ObjectFactory.class)) {
                return context.module();
            }
            if (clazz.equals(ValueBuilderFactory.class)) {
                return context.module();
            }
            if (clazz.equals(UnitOfWorkFactory.class)) {
                return context.module();
            }
            if (clazz.equals(QueryBuilderFactory.class)) {
                return context.module();
            }
            if (clazz.equals(ServiceFinder.class)) {
                return context.module();
            }
            if (Module.class.isAssignableFrom(clazz)) {
                return context.module();
            }
            if (ModuleSpi.class.isAssignableFrom(clazz)) {
                return context.module();
            }
            if (Layer.class.isAssignableFrom(clazz)) {
                return ((ModuleInstance)context.module()).layerInstance();
            }
            if (Application.class.isAssignableFrom(clazz)) {
                return ((ModuleInstance)context.module()).layerInstance().applicationInstance();
            }
            if (Qi4j.class.isAssignableFrom(clazz)) {
                return ((ModuleInstance)context.module()).layerInstance().applicationInstance().runtime();
            }
            return null;
        }
    }
}

