/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection.provider;

import java.lang.reflect.Constructor;
import org.qi4j.api.composite.NoSuchTransientException;
import org.qi4j.api.object.NoSuchObjectException;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.runtime.composite.UsesInstance;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderException;
import org.qi4j.runtime.model.Resolution;
import org.qi4j.spi.module.ModuleSpi;

public final class UsesInjectionProviderFactory
implements InjectionProviderFactory {
    @Override
    public InjectionProvider newInjectionProvider(Resolution resolution, DependencyModel dependencyModel) throws InvalidInjectionException {
        return new UsesInjectionProvider(dependencyModel);
    }

    private static class UsesInjectionProvider
    implements InjectionProvider {
        private final DependencyModel dependency;

        public UsesInjectionProvider(DependencyModel dependency) {
            this.dependency = dependency;
        }

        @Override
        public Object provideInjection(InjectionContext context) throws InjectionProviderException {
            Class<?> injectionType;
            UsesInstance uses = context.uses();
            Object usesObject = uses.useForType(injectionType = this.dependency.rawInjectionType());
            if (usesObject == null && !this.dependency.optional()) {
                ModuleSpi moduleInstance = context.module();
                try {
                    if (context.instance() != null) {
                        uses = uses.use(context.instance());
                    }
                    usesObject = moduleInstance.newTransient(injectionType, uses.toArray());
                }
                catch (NoSuchTransientException e) {
                    try {
                        usesObject = moduleInstance.newObject(injectionType, uses.toArray());
                    }
                    catch (NoSuchObjectException e1) {
                        try {
                            usesObject = injectionType.newInstance();
                        }
                        catch (Throwable e2) {
                            try {
                                Constructor<?> constructor = injectionType.getDeclaredConstructor(context.instance().getClass());
                                if (!constructor.isAccessible()) {
                                    constructor.setAccessible(true);
                                }
                                usesObject = constructor.newInstance(context.instance());
                            }
                            catch (Throwable e3) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (usesObject != null) {
                    context.setUses(context.uses().use(usesObject));
                }
                return usesObject;
            }
            return usesObject;
        }
    }
}

