/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.property.PropertyWrapper;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.MapType;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.runtime.property.PropertyInfo;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.value.ValueInstance;

public class PropertyInstance<T>
implements Property<T> {
    protected volatile T value;
    protected PropertyInfo model;

    public PropertyInstance(PropertyInfo model, T aValue) {
        this.model = model;
        this.value = aValue;
    }

    public PropertyInfo propertyInfo() {
        return this.model;
    }

    public void setPropertyInfo(PropertyInfo model) {
        this.model = model;
    }

    public T get() {
        return this.value;
    }

    public void set(T aNewValue) {
        if (this.model.isImmutable()) {
            throw new IllegalStateException("Property [" + this.model.qualifiedName() + "] is immutable.");
        }
        this.model.checkConstraints(aNewValue);
        this.value = aNewValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        while (that instanceof PropertyWrapper) {
            that = ((PropertyWrapper)that).next();
        }
        PropertyDescriptor thatDescriptor = (PropertyDescriptor)((PropertyInstance)that).propertyInfo();
        if (!this.model.equals(thatDescriptor)) {
            return false;
        }
        T value = this.get();
        if (value == null) {
            return that.get() == null;
        }
        return value.equals(that.get());
    }

    public int hashCode() {
        int hash = this.model.hashCode() * 19;
        T value = this.get();
        if (value != null) {
            hash += value.hashCode() * 13;
        }
        return hash;
    }

    public String toString() {
        T value = this.get();
        return value == null ? "" : value.toString();
    }

    public void prepareToBuild(PropertyModel propertyDescriptor) {
        T value;
        this.model = propertyDescriptor.getBuilderInfo();
        if (propertyDescriptor.valueType() instanceof ValueCompositeType) {
            T value2 = this.get();
            if (value2 != null) {
                ValueInstance.valueInstanceOf((ValueComposite)value2).prepareToBuild();
            }
        } else if (propertyDescriptor.valueType() instanceof CollectionType) {
            Object value3 = this.get();
            if (value3 != null) {
                if (value3 instanceof List) {
                    value3 = new ArrayList((Collection)value3);
                } else if (value3 instanceof Set) {
                    value3 = new LinkedHashSet((Collection)value3);
                }
                CollectionType collection = (CollectionType)propertyDescriptor.valueType();
                if (collection.collectedType() instanceof ValueCompositeType) {
                    Collection coll = (Collection)value3;
                    for (Object instance : coll) {
                        ValueInstance.valueInstanceOf((ValueComposite)instance).prepareToBuild();
                    }
                }
                this.set(value3);
            }
        } else if (propertyDescriptor.valueType() instanceof MapType && (value = this.get()) != null) {
            LinkedHashMap map = new LinkedHashMap((Map)value);
            MapType mapType = (MapType)propertyDescriptor.valueType();
            if (mapType.keyType() instanceof ValueCompositeType) {
                for (Object instance : map.keySet()) {
                    ValueInstance.valueInstanceOf((ValueComposite)instance).prepareToBuild();
                }
            }
            if (mapType.valueType() instanceof ValueCompositeType) {
                for (Object instance : map.values()) {
                    ValueInstance.valueInstanceOf((ValueComposite)instance).prepareToBuild();
                }
            }
            this.set(value);
        }
    }

    public void prepareBuilderState(PropertyModel propertyDescriptor) {
        Object value;
        if (propertyDescriptor.valueType() instanceof ValueCompositeType) {
            T value2 = this.get();
            if (value2 != null) {
                ValueInstance.valueInstanceOf((ValueComposite)value2).prepareBuilderState();
            }
        } else if (propertyDescriptor.valueType() instanceof CollectionType) {
            Object value3 = this.get();
            if (value3 != null) {
                CollectionType collection;
                if (propertyDescriptor.isImmutable()) {
                    value3 = value3 instanceof List ? Collections.unmodifiableList((List)value3) : (value3 instanceof Set ? Collections.unmodifiableSet((Set)value3) : Collections.unmodifiableCollection((Collection)value3));
                    this.value = value3;
                }
                if ((collection = (CollectionType)propertyDescriptor.valueType()).collectedType() instanceof ValueCompositeType) {
                    Collection coll = (Collection)value3;
                    for (Object instance : coll) {
                        ValueInstance.valueInstanceOf((ValueComposite)instance).prepareBuilderState();
                    }
                }
            }
        } else if (propertyDescriptor.valueType() instanceof MapType && (value = this.get()) != null) {
            Map map;
            MapType mapType = (MapType)propertyDescriptor.valueType();
            if (mapType.keyType() instanceof ValueCompositeType) {
                map = (Map)value;
                for (Object instance : map.keySet()) {
                    ValueInstance.valueInstanceOf((ValueComposite)instance).prepareBuilderState();
                }
            }
            if (mapType.valueType() instanceof ValueCompositeType) {
                map = (Map)value;
                for (Object instance : map.values()) {
                    ValueInstance.valueInstanceOf((ValueComposite)instance).prepareBuilderState();
                }
            }
            if (propertyDescriptor.isImmutable()) {
                value = Collections.unmodifiableMap((Map)value);
            }
            this.value = value;
        }
        this.model = propertyDescriptor;
    }
}

