/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.property;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.entity.Queryable;
import org.qi4j.api.property.DefaultValues;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.InvalidPropertyTypeException;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.Serialization;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Visitable;
import org.qi4j.functional.Visitor;
import org.qi4j.runtime.composite.ValueConstraintsInstance;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;
import org.qi4j.runtime.property.PropertyInfo;
import org.qi4j.runtime.types.ValueTypeFactory;

public class PropertyModel
implements PropertyDescriptor,
PropertyInfo,
Binder,
Visitable<PropertyModel> {
    private Type type;
    private transient AccessibleObject accessor;
    private final QualifiedName qualifiedName;
    private final ValueConstraintsInstance constraints;
    protected final MetaInfo metaInfo;
    private final Object initialValue;
    private final boolean useDefaults;
    private final boolean immutable;
    private ValueType valueType;
    protected PropertyInfo builderInfo;
    private final boolean queryable;

    public PropertyModel(AccessibleObject accessor, boolean immutable, boolean useDefaults, ValueConstraintsInstance constraints, MetaInfo metaInfo, Object initialValue) {
        Method m;
        if (accessor instanceof Method && !(m = (Method)accessor).getReturnType().equals(Property.class)) {
            throw new InvalidPropertyTypeException(accessor);
        }
        this.immutable = immutable;
        this.metaInfo = metaInfo;
        this.type = GenericPropertyInfo.propertyTypeOf((AccessibleObject)accessor);
        this.accessor = accessor;
        this.qualifiedName = QualifiedName.fromAccessor((AccessibleObject)accessor);
        this.useDefaults = useDefaults;
        this.initialValue = initialValue;
        this.constraints = constraints;
        Queryable queryable = accessor.getAnnotation(Queryable.class);
        this.queryable = queryable == null || queryable.value();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    public String name() {
        return this.qualifiedName.name();
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public AccessibleObject accessor() {
        return this.accessor;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    public PropertyInfo getBuilderInfo() {
        return this.builderInfo;
    }

    public boolean queryable() {
        return this.queryable;
    }

    public Object initialValue(Module module) {
        Object value = this.initialValue;
        if (value == null && this.useDefaults) {
            if (this.valueType instanceof ValueCompositeType) {
                return module.newValue((Class)Iterables.first((Iterable)this.valueType().types()));
            }
            value = DefaultValues.getDefaultValueOf((Type)this.type);
        }
        return value;
    }

    @Override
    public void bind(Resolution resolution) throws BindingException {
        ValueTypeFactory factory = ValueTypeFactory.instance();
        Class<?> declaringClass = ((Member)((Object)this.accessor())).getDeclaringClass();
        Class mainType = (Class)Iterables.first((Iterable)resolution.model().types());
        Serialization.Variant variant = this.findVariant();
        this.valueType = factory.newValueType(this.type(), declaringClass, mainType, resolution.layer(), resolution.module(), variant);
        this.builderInfo = new BuilderPropertyInfo();
        if (this.type instanceof TypeVariable) {
            this.type = Classes.resolveTypeVariable((TypeVariable)((TypeVariable)this.type), declaringClass, (Class)mainType);
        }
    }

    private Serialization.Variant findVariant() {
        Serialization serialization = (Serialization)this.metaInfo.get(Serialization.class);
        Serialization.Variant variant = null;
        if (serialization != null) {
            variant = serialization.value();
        }
        if (variant == null) {
            variant = Serialization.Variant.entry;
        }
        return variant;
    }

    public <ThrowableType extends Throwable> boolean accept(Visitor<? super PropertyModel, ThrowableType> visitor) throws ThrowableType {
        return visitor.visit((Object)this);
    }

    @Override
    public void checkConstraints(Object value) throws ConstraintViolationException {
        List<ConstraintViolation> violations;
        if (this.constraints != null && !(violations = this.constraints.checkConstraints(value)).isEmpty()) {
            Iterable empty = Iterables.empty();
            throw new ConstraintViolationException("<new instance>", empty, (Member)((Object)this.accessor), violations);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyModel that = (PropertyModel)o;
        return this.accessor.equals(that.accessor);
    }

    public int hashCode() {
        return this.accessor.hashCode();
    }

    public String toString() {
        if (this.accessor instanceof Field) {
            return ((Field)this.accessor).toGenericString();
        }
        return ((Method)this.accessor).toGenericString();
    }

    private class BuilderPropertyInfo
    implements PropertyInfo {
        private BuilderPropertyInfo() {
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public QualifiedName qualifiedName() {
            return PropertyModel.this.qualifiedName;
        }

        @Override
        public Type type() {
            return PropertyModel.this.type;
        }

        @Override
        public void checkConstraints(Object value) throws ConstraintViolationException {
            List<ConstraintViolation> violations;
            if (PropertyModel.this.constraints != null && !(violations = PropertyModel.this.constraints.checkConstraints(value)).isEmpty()) {
                Iterable empty = Iterables.empty();
                throw new ConstraintViolationException("<new instance>", empty, (Member)((Object)PropertyModel.this.accessor), violations);
            }
        }
    }
}

