/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.query;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.spi.query.QuerySource;

public class IterableQuerySource
implements QuerySource {
    private final Iterable iterable;

    IterableQuerySource(Iterable iterable) {
        this.iterable = iterable;
    }

    public <T> T find(Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
        Iterator<T> iterator = this.iterator(resultType, whereClause, orderBySegments, firstResult, maxResults, variables);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public <T> long count(Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
        return this.list(resultType, whereClause, orderBySegments, firstResult, maxResults, variables).size();
    }

    public <T> Iterator<T> iterator(Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
        return this.list(resultType, whereClause, orderBySegments, firstResult, maxResults, variables).iterator();
    }

    private <T> List<T> list(Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
        List<T> list = this.filter(resultType, whereClause);
        if (orderBySegments != null) {
            Collections.sort(list, new OrderByComparator(orderBySegments));
        }
        if (firstResult != null) {
            if (firstResult > list.size()) {
                return Collections.emptyList();
            }
            int toIdx = maxResults != null ? Math.min(firstResult + maxResults, list.size()) : list.size();
            list = list.subList(firstResult, toIdx);
        } else {
            int toIdx = maxResults != null ? Math.min(maxResults, list.size()) : list.size();
            list = list.subList(0, toIdx);
        }
        return list;
    }

    private <T> List<T> filter(Class<T> resultType, Specification whereClause) {
        if (whereClause == null) {
            return Iterables.toList((Iterable)Iterables.filter((Specification)Classes.instanceOf(resultType), (Iterable)this.iterable));
        }
        return Iterables.toList((Iterable)Iterables.filter((Specification)Specifications.and((Specification[])new Specification[]{Classes.instanceOf(resultType), whereClause}), (Iterable)this.iterable));
    }

    public String toString() {
        return "IterableQuerySource{" + this.iterable + '}';
    }

    private static class OrderByComparator<T extends Composite>
    implements Comparator<T> {
        private final Iterable<OrderBy> orderBySegments;

        private OrderByComparator(Iterable<OrderBy> orderBySegments) {
            this.orderBySegments = orderBySegments;
        }

        @Override
        public int compare(T o1, T o2) {
            for (OrderBy orderBySegment : this.orderBySegments) {
                try {
                    int result;
                    Property prop1 = orderBySegment.property().map(o1);
                    Property prop2 = orderBySegment.property().map(o2);
                    if (prop1 == null || prop2 == null) {
                        if (prop1 == null && prop2 == null) {
                            return 0;
                        }
                        if (prop1 != null) {
                            return 1;
                        }
                        return -1;
                    }
                    Object value1 = prop1.get();
                    Object value2 = prop2.get();
                    if (value1 == null || value2 == null) {
                        if (value1 == null && value2 == null) {
                            return 0;
                        }
                        if (value1 != null) {
                            return 1;
                        }
                        return -1;
                    }
                    if (!(value1 instanceof Comparable) || (result = ((Comparable)value1).compareTo(value2)) == 0) continue;
                    if (orderBySegment.order() == OrderBy.Order.ASCENDING) {
                        return result;
                    }
                    return -result;
                }
                catch (Exception e) {
                    return 0;
                }
            }
            return 0;
        }
    }
}

