/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.structure.Module;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.activation.ActivatorsInstance;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.service.ImportedServiceInstance;

public final class ImportedServiceModel
implements ImportedServiceDescriptor,
VisitableHierarchy<Object, Object> {
    private final Class<?> type;
    private final Visibility visibility;
    private final Class<? extends ServiceImporter> serviceImporter;
    private final String identity;
    private final boolean importOnStartup;
    private final MetaInfo metaInfo;
    private final ActivatorsModel<?> activatorsModel;
    private final String moduleName;

    public ImportedServiceModel(Class serviceType, Visibility visibility, Class<? extends ServiceImporter> serviceImporter, String identity, boolean importOnStartup, MetaInfo metaInfo, ActivatorsModel<?> activatorsModel, String moduleName) {
        this.type = serviceType;
        this.visibility = visibility;
        this.serviceImporter = serviceImporter;
        this.identity = identity;
        this.importOnStartup = importOnStartup;
        this.metaInfo = metaInfo;
        this.activatorsModel = activatorsModel;
        this.moduleName = moduleName;
    }

    public boolean isImportOnStartup() {
        return this.importOnStartup;
    }

    public Iterable<Class<?>> types() {
        Iterable iterable = Iterables.iterable((Object[])new Class[]{this.type});
        return iterable;
    }

    public Visibility visibility() {
        return this.visibility;
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    public Class<? extends ServiceImporter> serviceImporter() {
        return this.serviceImporter;
    }

    public Class<?> type() {
        return this.type;
    }

    public String identity() {
        return this.identity;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public ActivatorsInstance<?> newActivatorsInstance(Module module) throws Exception {
        return new ActivatorsInstance(this.activatorsModel.newInstances(module));
    }

    public boolean isAssignableTo(Class<?> type) {
        return this.type.isAssignableFrom(type);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this)) {
            this.activatorsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    public <T> ImportedServiceInstance<T> importInstance(Module module) {
        ServiceImporter importer = (ServiceImporter)module.newObject(this.serviceImporter, new Object[0]);
        try {
            Object instance = importer.importService((ImportedServiceDescriptor)this);
            return new ImportedServiceInstance<Object>(instance, importer);
        }
        catch (ServiceImporterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceImporterException("Could not import service " + this.identity, (Throwable)e);
        }
    }

    public Object newProxy(InvocationHandler serviceInvocationHandler) {
        if (this.type.isInterface()) {
            return Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, serviceInvocationHandler);
        }
        Class<?>[] interfaces = this.type.getInterfaces();
        return Proxy.newProxyInstance(this.type.getClassLoader(), interfaces, serviceInvocationHandler);
    }

    public String toString() {
        return this.type.getName() + ":" + this.identity;
    }
}

