/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.service;

import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.ServiceUnavailableException;
import org.qi4j.api.structure.Module;
import org.qi4j.runtime.activation.ActivationDelegate;
import org.qi4j.runtime.service.ImportedServiceInstance;
import org.qi4j.runtime.service.ImportedServiceModel;

public final class ImportedServiceReferenceInstance<T>
implements ServiceReference<T>,
Activation {
    private volatile ImportedServiceInstance<T> serviceInstance;
    private T instance;
    private final Module module;
    private final ImportedServiceModel serviceModel;
    private final ActivationDelegate activation = new ActivationDelegate(this);
    private boolean active = false;

    public ImportedServiceReferenceInstance(ImportedServiceModel serviceModel, Module module) {
        this.module = module;
        this.serviceModel = serviceModel;
    }

    public String identity() {
        return this.serviceModel.identity();
    }

    public Iterable<Class<?>> types() {
        return this.serviceModel.types();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return this.serviceModel.metaInfo(infoType);
    }

    public synchronized T get() {
        return this.getInstance();
    }

    public ImportedServiceModel serviceDescriptor() {
        return this.serviceModel;
    }

    public void activate() throws ActivationException {
        if (this.serviceModel.isImportOnStartup()) {
            this.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate() throws PassivationException {
        if (this.serviceInstance != null) {
            try {
                this.activation.passivate(new Runnable(){

                    @Override
                    public void run() {
                        ImportedServiceReferenceInstance.this.active = false;
                    }
                });
            }
            finally {
                this.serviceInstance = null;
                this.active = false;
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAvailable() {
        try {
            this.getInstance();
            return this.serviceInstance.isAvailable();
        }
        catch (ServiceImporterException ex) {
            return false;
        }
    }

    public Module module() {
        return this.module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getInstance() throws ServiceImporterException {
        if (this.serviceInstance == null) {
            ImportedServiceReferenceInstance importedServiceReferenceInstance = this;
            synchronized (importedServiceReferenceInstance) {
                if (this.serviceInstance == null) {
                    this.serviceInstance = this.serviceModel.importInstance(this.module);
                    this.instance = this.serviceInstance.instance();
                    try {
                        this.activation.activate(this.serviceModel.newActivatorsInstance(this.module), this.serviceInstance, new Runnable(){

                            @Override
                            public void run() {
                                ImportedServiceReferenceInstance.this.active = true;
                            }
                        });
                    }
                    catch (Exception e) {
                        this.serviceInstance = null;
                        throw new ServiceUnavailableException("Could not activate service " + this.serviceModel.identity(), (Throwable)e);
                    }
                }
            }
        }
        return this.instance;
    }

    public String toString() {
        return this.serviceModel.identity() + ", active=" + this.isActive() + ", module='" + this.serviceModel.moduleName() + "'";
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activation.registerActivationEventListener(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activation.deregisterActivationEventListener(listener);
    }

    public int hashCode() {
        return this.identity().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceReference other = (ServiceReference)obj;
        return this.identity().equals(other.identity());
    }
}

