/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.ServiceUnavailableException;
import org.qi4j.api.structure.Module;
import org.qi4j.runtime.activation.ActivationDelegate;
import org.qi4j.runtime.service.ServiceInstance;
import org.qi4j.runtime.service.ServiceModel;
import org.qi4j.runtime.structure.ModuleInstance;

public final class ServiceReferenceInstance<T>
implements ServiceReference<T>,
Activation {
    private volatile ServiceInstance instance;
    private final T serviceProxy;
    private final ModuleInstance module;
    private final ServiceModel serviceModel;
    private final ActivationDelegate activation = new ActivationDelegate(this);
    private boolean active = false;

    public ServiceReferenceInstance(ServiceModel serviceModel, ModuleInstance module) {
        this.module = module;
        this.serviceModel = serviceModel;
        this.serviceProxy = this.newProxy();
    }

    public String identity() {
        return this.serviceModel.identity();
    }

    public Iterable<Class<?>> types() {
        return this.serviceModel.types();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return this.serviceModel.metaInfo(infoType);
    }

    public synchronized T get() {
        return this.serviceProxy;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAvailable() {
        return this.getInstance().isAvailable();
    }

    public Module module() {
        return this.module;
    }

    public void activate() throws ActivationException {
        if (this.serviceModel.isInstantiateOnStartup()) {
            this.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate() throws PassivationException {
        if (this.instance != null) {
            try {
                this.activation.passivate(new Runnable(){

                    @Override
                    public void run() {
                        ServiceReferenceInstance.this.active = false;
                    }
                });
            }
            finally {
                this.instance = null;
                this.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInstance getInstance() throws ServiceImporterException {
        if (this.instance == null) {
            ServiceReferenceInstance serviceReferenceInstance = this;
            synchronized (serviceReferenceInstance) {
                if (this.instance == null) {
                    this.instance = this.serviceModel.newInstance(this.module);
                    try {
                        this.activation.activate(this.serviceModel.newActivatorsInstance(this.module), this.instance, new Runnable(){

                            @Override
                            public void run() {
                                ServiceReferenceInstance.this.active = true;
                            }
                        });
                    }
                    catch (Exception e) {
                        this.instance = null;
                        throw new ServiceUnavailableException("Could not activate service " + this.serviceModel.identity(), (Throwable)e);
                    }
                }
            }
        }
        return this.instance;
    }

    public String toString() {
        return this.serviceModel.identity() + "(active=" + this.isActive() + ",module='" + this.module.name() + "')";
    }

    public T newProxy() {
        return (T)this.serviceModel.newProxy((InvocationHandler)((Object)new ServiceInvocationHandler()));
    }

    public ServiceDescriptor serviceDescriptor() {
        return this.serviceModel;
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activation.registerActivationEventListener(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activation.deregisterActivationEventListener(listener);
    }

    public int hashCode() {
        return this.identity().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceReference other = (ServiceReference)obj;
        return this.identity().equals(other.identity());
    }

    public final class ServiceInvocationHandler
    implements CompositeInstance {
        public <T> T proxy() {
            return ServiceReferenceInstance.this.get();
        }

        public <T> T newProxy(Class<T> mixinType) throws IllegalArgumentException {
            return ServiceReferenceInstance.this.getInstance().newProxy(mixinType);
        }

        public <T> T metaInfo(Class<T> infoType) {
            return ServiceReferenceInstance.this.metaInfo(infoType);
        }

        public Iterable<Class<?>> types() {
            return ServiceReferenceInstance.this.types();
        }

        public CompositeDescriptor descriptor() {
            return ServiceReferenceInstance.this.serviceDescriptor();
        }

        public Object invokeComposite(Method method, Object[] args) throws Throwable {
            return ServiceReferenceInstance.this.getInstance().invokeComposite(method, args);
        }

        public StateHolder state() {
            return ServiceReferenceInstance.this.getInstance().state();
        }

        public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                switch (method.getName()) {
                    case "toString": {
                        return ServiceReferenceInstance.this.serviceModel.toString();
                    }
                    case "equals": {
                        return objects[0] == object;
                    }
                    case "hashCode": {
                        return ServiceReferenceInstance.this.serviceModel.toString().hashCode();
                    }
                }
            }
            ServiceInstance instance = ServiceReferenceInstance.this.getInstance();
            return instance.invoke(object, method, objects);
        }

        public String toString() {
            return ServiceReferenceInstance.this.serviceModel.toString();
        }

        public Module module() {
            return ServiceReferenceInstance.this.module;
        }
    }
}

