/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.service;

import java.util.List;
import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationEventListenerRegistration;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.runtime.activation.ActivationDelegate;
import org.qi4j.runtime.activation.ActivatorsInstance;
import org.qi4j.runtime.service.ServiceReferenceInstance;
import org.qi4j.runtime.service.ServicesModel;

public class ServicesInstance
implements Activation,
ActivationEventListenerRegistration {
    private final ServicesModel servicesModel;
    private final List<ServiceReference> serviceReferences;
    private final ActivationDelegate activation = new ActivationDelegate(this, false);

    public ServicesInstance(ServicesModel servicesModel, List<ServiceReference> serviceReferences) {
        this.servicesModel = servicesModel;
        this.serviceReferences = serviceReferences;
        for (ServiceReference serviceReference : serviceReferences) {
            serviceReference.registerActivationEventListener((ActivationEventListener)this.activation);
        }
    }

    public void activate() throws ActivationException {
        Iterable activatees = Iterables.cast((Iterable)Iterables.filter((Specification)Classes.instanceOf(Activation.class), this.serviceReferences));
        this.activation.activate(ActivatorsInstance.EMPTY, activatees);
    }

    public void passivate() throws PassivationException {
        this.activation.passivate();
    }

    public Iterable<ServiceReference> visibleServices(final Visibility visibility) {
        return Iterables.filter((Specification)new Specification<ServiceReference>(){

            public boolean satisfiedBy(ServiceReference item) {
                return ((ServiceReferenceInstance)item).serviceDescriptor().visibility().ordinal() >= visibility.ordinal();
            }
        }, this.serviceReferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Services{");
        String sep = " ";
        for (ServiceReference serviceReference : this.serviceReferences) {
            sb.append(sep).append(serviceReference.identity()).append("(active=").append(serviceReference.isActive()).append(")");
            sep = ", ";
        }
        return sb.append(" }").toString();
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activation.registerActivationEventListener(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activation.deregisterActivationEventListener(listener);
    }
}

