/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.api.structure.Layer;
import org.qi4j.api.structure.Module;
import org.qi4j.bootstrap.Qi4jRuntime;
import org.qi4j.runtime.activation.ActivationDelegate;
import org.qi4j.runtime.structure.ApplicationModel;
import org.qi4j.runtime.structure.LayerInstance;

public class ApplicationInstance
implements Application {
    private final ApplicationModel applicationModel;
    private final Qi4jRuntime runtime;
    private final MetaInfo instanceMetaInfo;
    private final ActivationDelegate activation;
    private final List<LayerInstance> layerInstances;

    public ApplicationInstance(ApplicationModel model, Qi4jRuntime runtime, MetaInfo instanceMetaInfo) {
        this.applicationModel = model;
        this.runtime = runtime;
        this.instanceMetaInfo = instanceMetaInfo;
        this.activation = new ActivationDelegate(this);
        this.layerInstances = new ArrayList<LayerInstance>();
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return this.applicationModel.name();
    }

    public String version() {
        return this.applicationModel.version();
    }

    public Application.Mode mode() {
        return this.applicationModel.mode();
    }

    public Layer findLayer(String layerName) {
        for (LayerInstance layerInstance : this.layerInstances) {
            if (!layerInstance.model().name().equals(layerName)) continue;
            return layerInstance;
        }
        throw new IllegalArgumentException("No such layer:" + layerName);
    }

    public Module findModule(String layerName, String moduleName) {
        for (LayerInstance layerInstance : this.layerInstances) {
            if (!layerInstance.model().name().equals(layerName)) continue;
            return layerInstance.findModule(moduleName);
        }
        throw new IllegalArgumentException("No such layer:" + layerName);
    }

    public ApplicationDescriptor descriptor() {
        return this.applicationModel;
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.instanceMetaInfo.get(infoType);
    }

    public void activate() throws ActivationException {
        this.activation.activate(this.applicationModel.newActivatorsInstance(), this.layerInstances);
    }

    public void passivate() throws PassivationException {
        this.activation.passivate();
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activation.registerActivationEventListener(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activation.deregisterActivationEventListener(listener);
    }

    void addLayer(LayerInstance layer) {
        layer.registerActivationEventListener(this.activation);
        this.layerInstances.add(layer);
    }

    public Qi4jRuntime runtime() {
        return this.runtime;
    }
}

