/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.qi4j.api.Qi4j;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.common.InvalidApplicationException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.bootstrap.Qi4jRuntime;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.runtime.activation.ActivatorsInstance;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderFactoryStrategy;
import org.qi4j.runtime.structure.ApplicationInstance;
import org.qi4j.runtime.structure.LayerInstance;
import org.qi4j.runtime.structure.LayerModel;
import org.qi4j.runtime.structure.UsedLayersInstance;

public final class ApplicationModel
implements ApplicationDescriptor {
    private final String name;
    private final String version;
    private final Application.Mode mode;
    private final MetaInfo metaInfo;
    private final ActivatorsModel<Application> activatorsModel;
    private final List<LayerModel> layers;
    private final InjectionProviderFactory ipf;

    public ApplicationModel(String name, String version, Application.Mode mode, MetaInfo metaInfo, ActivatorsModel<Application> activatorsModel, List<LayerModel> layers) {
        this.name = name;
        this.version = version;
        this.mode = mode;
        this.metaInfo = metaInfo;
        this.activatorsModel = activatorsModel;
        this.layers = layers;
        this.ipf = new InjectionProviderFactoryStrategy(metaInfo);
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Application.Mode mode() {
        return this.mode;
    }

    public MetaInfo metaInfo() {
        return this.metaInfo;
    }

    public ActivatorsInstance<Application> newActivatorsInstance() throws ActivationException {
        return new ActivatorsInstance<Application>(this.activatorsModel.newInstances());
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        block1: {
            if (!visitor.visitEnter((Object)this) || !this.activatorsModel.accept(visitor)) break block1;
            for (LayerModel layer : this.layers) {
                if (!layer.accept(visitor)) break;
            }
        }
        return visitor.visitLeave((Object)this);
    }

    public ApplicationInstance newInstance(Qi4j runtime, Object ... importedServiceInstances) throws InvalidApplicationException {
        List<LayerInstance> usedLayerInstances;
        MetaInfo instanceMetaInfo = new MetaInfo(this.metaInfo);
        for (Object importedServiceInstance : importedServiceInstances) {
            instanceMetaInfo.set(importedServiceInstance);
        }
        ApplicationInstance applicationInstance = new ApplicationInstance(this, (Qi4jRuntime)runtime, instanceMetaInfo);
        HashMap<LayerModel, LayerInstance> layerInstanceMap = new HashMap<LayerModel, LayerInstance>();
        HashMap<LayerModel, ArrayList<LayerInstance>> usedLayers = new HashMap<LayerModel, ArrayList<LayerInstance>>();
        for (LayerModel layer : this.layers) {
            usedLayerInstances = new ArrayList<LayerInstance>();
            usedLayers.put(layer, (ArrayList<LayerInstance>)usedLayerInstances);
            UsedLayersInstance usedLayersInstance = layer.usedLayers().newInstance(usedLayerInstances);
            LayerInstance layerInstance = layer.newInstance(applicationInstance, usedLayersInstance);
            applicationInstance.addLayer(layerInstance);
            layerInstanceMap.put(layer, layerInstance);
        }
        for (LayerModel layer : this.layers) {
            usedLayerInstances = (List)usedLayers.get(layer);
            for (LayerModel usedLayer : layer.usedLayers().layers()) {
                LayerInstance layerInstance = (LayerInstance)layerInstanceMap.get(usedLayer);
                if (layerInstance == null) {
                    throw new InvalidApplicationException("Could not find used layer:" + usedLayer.name());
                }
                usedLayerInstances.add(layerInstance);
            }
        }
        return applicationInstance;
    }

    public InjectionProviderFactory injectionProviderFactory() {
        return this.ipf;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationModel");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", mode=").append(this.mode);
        sb.append('}');
        return sb.toString();
    }
}

