/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.entity.IdentityGenerator;
import org.qi4j.api.entity.LifecycleException;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryExecutionException;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.service.NoSuchServiceException;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCallback;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.runtime.association.AssociationInstance;
import org.qi4j.runtime.association.ManyAssociationInstance;
import org.qi4j.runtime.association.NamedAssociationInstance;
import org.qi4j.runtime.composite.FunctionStateResolver;
import org.qi4j.runtime.entity.EntityInstance;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.unitofwork.EntityBuilderInstance;
import org.qi4j.runtime.unitofwork.UnitOfWorkInstance;
import org.qi4j.runtime.value.ValueInstance;
import org.qi4j.runtime.value.ValueStateInstance;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.NamedAssociationState;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;
import org.qi4j.spi.query.QueryBuilderSPI;
import org.qi4j.spi.query.QuerySource;

public class ModuleUnitOfWork
implements UnitOfWork {
    private static final QualifiedName IDENTITY_STATE_NAME;
    private final UnitOfWorkInstance uow;
    private final ModuleInstance module;

    ModuleUnitOfWork(ModuleInstance module, UnitOfWorkInstance uow) {
        this.module = module;
        this.uow = uow;
    }

    public ModuleInstance module() {
        return this.module;
    }

    public UnitOfWorkInstance instance() {
        return this.uow;
    }

    public UnitOfWorkFactory unitOfWorkFactory() {
        return this.module;
    }

    public long currentTime() {
        return this.uow.currentTime();
    }

    public Usecase usecase() {
        return this.uow.usecase();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.uow.metaInfo().get(infoType);
    }

    public void setMetaInfo(Object metaInfo) {
        this.uow.metaInfo().set(metaInfo);
    }

    public <T> Query<T> newQuery(QueryBuilder<T> queryBuilder) {
        QueryBuilderSPI queryBuilderSPI = (QueryBuilderSPI)queryBuilder;
        return queryBuilderSPI.newQuery((QuerySource)new UoWQuerySource(this));
    }

    public <T> T newEntity(Class<T> type) throws EntityTypeNotFoundException, LifecycleException {
        return this.newEntity(type, null);
    }

    public <T> T newEntity(Class<T> type, String identity) throws EntityTypeNotFoundException, LifecycleException {
        return (T)this.newEntityBuilder(type, identity).newInstance();
    }

    public <T> EntityBuilder<T> newEntityBuilder(Class<T> type) throws EntityTypeNotFoundException {
        return this.newEntityBuilder(type, null);
    }

    public <T> EntityBuilder<T> newEntityBuilder(Class<T> type, String identity) throws EntityTypeNotFoundException {
        ModelModule<EntityModel> model = this.module.typeLookup().lookupEntityModel(type);
        if (model == null) {
            throw new EntityTypeNotFoundException(type.getName(), this.module.name(), Iterables.map((Function)ModelModule.toStringFunction, this.module.findVisibleEntityTypes()));
        }
        EntityStore entityStore = model.module().entityStore();
        if (identity == null) {
            IdentityGenerator idGen = model.module().identityGenerator();
            if (idGen == null) {
                throw new NoSuchServiceException(IdentityGenerator.class.getName(), model.module().name());
            }
            identity = idGen.generate((Class)Iterables.first(((EntityModel)model.model()).types()));
        }
        EntityBuilderInstance builder = new EntityBuilderInstance(model, this, this.uow.getEntityStoreUnitOfWork(entityStore, this.module), identity);
        return builder;
    }

    public <T> EntityBuilder<T> newEntityBuilderWithState(Class<T> type, Function<PropertyDescriptor, Object> propertyFunction, Function<AssociationDescriptor, EntityReference> associationFunction, Function<AssociationDescriptor, Iterable<EntityReference>> manyAssociationFunction, Function<AssociationDescriptor, Map<String, EntityReference>> namedAssociationFunction) throws EntityTypeNotFoundException {
        return this.newEntityBuilderWithState(type, null, propertyFunction, associationFunction, manyAssociationFunction, namedAssociationFunction);
    }

    public <T> EntityBuilder<T> newEntityBuilderWithState(Class<T> type, String identity, Function<PropertyDescriptor, Object> propertyFunction, Function<AssociationDescriptor, EntityReference> associationFunction, Function<AssociationDescriptor, Iterable<EntityReference>> manyAssociationFunction, Function<AssociationDescriptor, Map<String, EntityReference>> namedAssociationFunction) throws EntityTypeNotFoundException {
        PropertyModel identityModel;
        NullArgumentException.validateNotNull((String)"propertyFunction", propertyFunction);
        NullArgumentException.validateNotNull((String)"associationFunction", associationFunction);
        NullArgumentException.validateNotNull((String)"manyAssociationFunction", manyAssociationFunction);
        NullArgumentException.validateNotNull((String)"namedAssociationFunction", namedAssociationFunction);
        ModelModule<EntityModel> model = this.module.typeLookup().lookupEntityModel(type);
        if (model == null) {
            throw new EntityTypeNotFoundException(type.getName(), this.module.name(), Iterables.map((Function)ModelModule.toStringFunction, this.module.findVisibleEntityTypes()));
        }
        EntityStore entityStore = model.module().entityStore();
        FunctionStateResolver stateResolver = new FunctionStateResolver(propertyFunction, associationFunction, manyAssociationFunction, namedAssociationFunction);
        if (identity == null && (identity = (String)stateResolver.getPropertyState(identityModel = ((EntityModel)model.model()).state().findPropertyModelByQualifiedName(IDENTITY_STATE_NAME))) == null) {
            IdentityGenerator idGen = model.module().identityGenerator();
            if (idGen == null) {
                throw new NoSuchServiceException(IdentityGenerator.class.getName(), model.module().name());
            }
            identity = idGen.generate((Class)Iterables.first(((EntityModel)model.model()).types()));
        }
        return new EntityBuilderInstance(model, this, this.uow.getEntityStoreUnitOfWork(entityStore, this.module), identity, stateResolver);
    }

    public <T> T get(Class<T> type, String identity) throws EntityTypeNotFoundException, NoSuchEntityException {
        Iterable<ModelModule<EntityModel>> models = this.module.typeLookup().lookupEntityModels(type);
        if (!models.iterator().hasNext()) {
            throw new EntityTypeNotFoundException(type.getName(), this.module.name(), Iterables.map((Function)ModelModule.toStringFunction, this.module.findVisibleEntityTypes()));
        }
        return this.uow.get(EntityReference.parseEntityReference((String)identity), this, models, type);
    }

    public <T> T get(T entity) throws EntityTypeNotFoundException {
        EntityComposite entityComposite = (EntityComposite)entity;
        EntityInstance compositeInstance = EntityInstance.entityInstanceOf(entityComposite);
        ModelModule model = new ModelModule(compositeInstance.module(), (ModelDescriptor)compositeInstance.entityModel());
        Class type = (Class)Iterables.first(compositeInstance.types());
        return this.uow.get(compositeInstance.identity(), this, Collections.singletonList(model), type);
    }

    public void remove(Object entity) throws LifecycleException {
        this.uow.checkOpen();
        EntityComposite entityComposite = (EntityComposite)entity;
        EntityInstance compositeInstance = EntityInstance.entityInstanceOf(entityComposite);
        if (compositeInstance.status() == EntityStatus.NEW) {
            compositeInstance.remove(this);
            this.uow.remove(compositeInstance.identity());
        } else if (compositeInstance.status() == EntityStatus.LOADED || compositeInstance.status() == EntityStatus.UPDATED) {
            compositeInstance.remove(this);
        } else {
            throw new NoSuchEntityException(compositeInstance.identity(), compositeInstance.types(), this.usecase());
        }
    }

    public void complete() throws UnitOfWorkCompletionException, ConcurrentEntityModificationException {
        this.uow.complete();
    }

    public void discard() {
        this.uow.discard();
    }

    public void close() {
        this.discard();
    }

    public boolean isOpen() {
        return this.uow.isOpen();
    }

    public boolean isPaused() {
        return this.uow.isPaused();
    }

    public void pause() {
        this.uow.pause();
    }

    public void resume() {
        this.uow.resume();
    }

    public void addUnitOfWorkCallback(UnitOfWorkCallback callback) {
        this.uow.addUnitOfWorkCallback(callback);
    }

    public void removeUnitOfWorkCallback(UnitOfWorkCallback callback) {
        this.uow.removeUnitOfWorkCallback(callback);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleUnitOfWork that = (ModuleUnitOfWork)o;
        return this.uow.equals(that.uow);
    }

    public int hashCode() {
        return this.uow.hashCode();
    }

    public String toString() {
        return this.uow.toString();
    }

    public void addEntity(EntityInstance instance) {
        this.uow.addEntity(instance);
    }

    public <T extends Identity> T toValue(Class<T> primaryType, T entityComposite) {
        ToValuePropertyMappingFunction propertyFunction = new ToValuePropertyMappingFunction(entityComposite);
        ToValueAssociationMappingFunction<T> assocationFunction = new ToValueAssociationMappingFunction<T>(entityComposite);
        ToValueManyAssociationMappingFunction<T> manyAssocFunction = new ToValueManyAssociationMappingFunction<T>(entityComposite);
        ToValueNameAssociationMappingFunction<T> namedAssocFunction = new ToValueNameAssociationMappingFunction<T>(entityComposite);
        ValueBuilder<T> builder = this.module().newValueBuilderWithState(primaryType, propertyFunction, assocationFunction, manyAssocFunction, namedAssocFunction);
        return (T)((Identity)builder.newInstance());
    }

    public <T extends Identity> T toEntity(Class<T> primaryType, T valueComposite) {
        ToEntityPropertyMappingFunction<T> propertyFunction = new ToEntityPropertyMappingFunction<T>(valueComposite);
        ToEntityAssociationMappingFunction<T> assocationFunction = new ToEntityAssociationMappingFunction<T>(valueComposite);
        ToEntityManyAssociationMappingFunction<T> manyAssocFunction = new ToEntityManyAssociationMappingFunction<T>(valueComposite);
        ToEntityNameAssociationMappingFunction<T> namedAssocFunction = new ToEntityNameAssociationMappingFunction<T>(valueComposite);
        String identity = (String)valueComposite.identity().get();
        try {
            Identity entity = (Identity)this.get(primaryType, identity);
            EntityInstance instance = EntityInstance.entityInstanceOf((EntityComposite)entity);
            EntityState state = instance.entityState();
            FunctionStateResolver stateResolver = new FunctionStateResolver(propertyFunction, assocationFunction, manyAssocFunction, namedAssocFunction);
            EntityModel model = (EntityModel)EntityInstance.entityInstanceOf((EntityComposite)entity).descriptor();
            stateResolver.populateState(model, state);
            return (T)entity;
        }
        catch (NoSuchEntityException e) {
            EntityBuilder<T> entityBuilder = this.newEntityBuilderWithState(primaryType, identity, propertyFunction, assocationFunction, manyAssocFunction, namedAssocFunction);
            return (T)((Identity)entityBuilder.newInstance());
        }
    }

    static {
        try {
            IDENTITY_STATE_NAME = QualifiedName.fromAccessor((AccessibleObject)Identity.class.getMethod("identity", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Zest Core Runtime codebase is corrupted. Contact Zest team: ModuleUnitOfWork");
        }
    }

    private class ToEntityNameAssociationMappingFunction<T>
    implements Function<AssociationDescriptor, Map<String, EntityReference>> {
        private final T value;

        public ToEntityNameAssociationMappingFunction(T valueComposite) {
            this.value = valueComposite;
        }

        public Map<String, EntityReference> map(AssociationDescriptor associationDescriptor) {
            ValueStateInstance state = ValueInstance.valueInstanceOf((ValueComposite)this.value).state();
            NamedAssociationInstance association = (NamedAssociationInstance)state.namedAssociationFor(associationDescriptor.accessor());
            HashMap<String, EntityReference> result = new HashMap<String, EntityReference>();
            for (Map.Entry<String, EntityReference> entry : association.getEntityReferences()) {
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }

    private class ToEntityManyAssociationMappingFunction<T>
    implements Function<AssociationDescriptor, Iterable<EntityReference>> {
        private final T value;

        public ToEntityManyAssociationMappingFunction(T valueComposite) {
            this.value = valueComposite;
        }

        public Iterable<EntityReference> map(AssociationDescriptor associationDescriptor) {
            ValueStateInstance state = ValueInstance.valueInstanceOf((ValueComposite)this.value).state();
            ManyAssociationInstance association = (ManyAssociationInstance)state.manyAssociationFor(associationDescriptor.accessor());
            return association.getManyAssociationState();
        }
    }

    private class ToEntityAssociationMappingFunction<T>
    implements Function<AssociationDescriptor, EntityReference> {
        private final T value;

        public ToEntityAssociationMappingFunction(T value) {
            this.value = value;
        }

        public EntityReference map(AssociationDescriptor associationDescriptor) {
            ValueStateInstance state = ValueInstance.valueInstanceOf((ValueComposite)this.value).state();
            AssociationInstance association = (AssociationInstance)state.associationFor(associationDescriptor.accessor());
            return (EntityReference)association.getAssociationState().get();
        }
    }

    private class ToEntityPropertyMappingFunction<T>
    implements Function<PropertyDescriptor, Object> {
        private final T value;

        public ToEntityPropertyMappingFunction(T value) {
            this.value = value;
        }

        public Object map(PropertyDescriptor propertyDescriptor) {
            ValueStateInstance state = ValueInstance.valueInstanceOf((ValueComposite)this.value).state();
            Property property = state.propertyFor(propertyDescriptor.accessor());
            return property.get();
        }
    }

    private class ToValueNameAssociationMappingFunction<T>
    implements Function<AssociationDescriptor, Map<String, EntityReference>> {
        private final T entity;

        public ToValueNameAssociationMappingFunction(T entity) {
            this.entity = entity;
        }

        public Map<String, EntityReference> map(AssociationDescriptor associationDescriptor) {
            HashMap<String, EntityReference> result = new HashMap<String, EntityReference>();
            EntityState entityState = EntityInstance.entityInstanceOf((EntityComposite)this.entity).entityState();
            NamedAssociationState state = entityState.namedAssociationValueOf(associationDescriptor.qualifiedName());
            for (String name : state) {
                result.put(name, state.get(name));
            }
            return result;
        }
    }

    private class ToValueManyAssociationMappingFunction<T>
    implements Function<AssociationDescriptor, Iterable<EntityReference>> {
        private final T entity;

        public ToValueManyAssociationMappingFunction(T entity) {
            this.entity = entity;
        }

        public Iterable<EntityReference> map(AssociationDescriptor associationDescriptor) {
            EntityState entityState = EntityInstance.entityInstanceOf((EntityComposite)this.entity).entityState();
            return entityState.manyAssociationValueOf(associationDescriptor.qualifiedName());
        }
    }

    private class ToValueAssociationMappingFunction<T>
    implements Function<AssociationDescriptor, EntityReference> {
        private final T entity;

        public ToValueAssociationMappingFunction(T entity) {
            this.entity = entity;
        }

        public EntityReference map(AssociationDescriptor associationDescriptor) {
            EntityState entityState = EntityInstance.entityInstanceOf((EntityComposite)this.entity).entityState();
            return entityState.associationValueOf(associationDescriptor.qualifiedName());
        }
    }

    private class ToValuePropertyMappingFunction
    implements Function<PropertyDescriptor, Object> {
        private Object entity;

        public ToValuePropertyMappingFunction(Object entity) {
            this.entity = entity;
        }

        public Object map(PropertyDescriptor propertyDescriptor) {
            EntityState entityState = EntityInstance.entityInstanceOf((EntityComposite)this.entity).entityState();
            return entityState.propertyValueOf(propertyDescriptor.qualifiedName());
        }
    }

    private static class UoWQuerySource
    implements QuerySource {
        private final ModuleUnitOfWork moduleUnitOfWork;

        private UoWQuerySource(ModuleUnitOfWork moduleUnitOfWork) {
            this.moduleUnitOfWork = moduleUnitOfWork;
        }

        public <T> T find(Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
            EntityFinder entityFinder = (EntityFinder)this.moduleUnitOfWork.module().findService(EntityFinder.class).get();
            try {
                EntityReference foundEntity = entityFinder.findEntity(resultType, whereClause, variables == null ? Collections.emptyMap() : variables);
                if (foundEntity != null) {
                    try {
                        return this.moduleUnitOfWork.get(resultType, foundEntity.identity());
                    }
                    catch (NoSuchEntityException e) {
                        return null;
                    }
                }
                return null;
            }
            catch (EntityFinderException e) {
                throw new QueryExecutionException("Finder caused exception", (Throwable)e);
            }
        }

        public <T> long count(Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
            EntityFinder entityFinder = (EntityFinder)this.moduleUnitOfWork.module().findService(EntityFinder.class).get();
            try {
                return entityFinder.countEntities(resultType, whereClause, variables == null ? Collections.emptyMap() : variables);
            }
            catch (EntityFinderException e) {
                e.printStackTrace();
                return 0L;
            }
        }

        public <T> Iterator<T> iterator(final Class<T> resultType, Specification<Composite> whereClause, Iterable<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) {
            EntityFinder entityFinder = (EntityFinder)this.moduleUnitOfWork.module().findService(EntityFinder.class).get();
            try {
                final Iterator foundEntities = entityFinder.findEntities(resultType, whereClause, (OrderBy[])Iterables.toArray(OrderBy.class, orderBySegments), firstResult, maxResults, variables == null ? Collections.emptyMap() : variables).iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return foundEntities.hasNext();
                    }

                    @Override
                    public T next() {
                        EntityReference foundEntity = (EntityReference)foundEntities.next();
                        try {
                            return UoWQuerySource.this.moduleUnitOfWork.get(resultType, foundEntity.identity());
                        }
                        catch (NoSuchEntityException e) {
                            return null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            catch (EntityFinderException e) {
                throw new QueryExecutionException("Query '" + this.toString() + "' could not be executed", (Throwable)e);
            }
        }

        public String toString() {
            return "UnitOfWork( " + this.moduleUnitOfWork.usecase().name() + " )";
        }
    }
}

