/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.AmbiguousTypeException;
import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.api.service.NoSuchServiceException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.runtime.composite.TransientModel;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.object.ObjectModel;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.spi.module.ModelModule;

public class TypeLookup {
    private final ModuleInstance moduleInstance;
    private final Map<Class<?>, ModelModule<ObjectModel>> objectModels;
    private final Map<Class<?>, ModelModule<TransientModel>> transientModels;
    private final Map<Class<?>, ModelModule<ValueModel>> valueModels;
    private final Map<Class<?>, Iterable<ModelModule<EntityModel>>> allEntityModels;
    private final Map<Class<?>, ModelModule<EntityModel>> unambiguousEntityModels;
    private final Map<Type, ServiceReference<?>> serviceReferences;
    private final Map<Type, Iterable<ServiceReference<?>>> servicesReferences;

    TypeLookup(ModuleInstance moduleInstance) {
        this.moduleInstance = moduleInstance;
        this.objectModels = new ConcurrentHashMap();
        this.transientModels = new ConcurrentHashMap();
        this.valueModels = new ConcurrentHashMap();
        this.allEntityModels = new ConcurrentHashMap();
        this.unambiguousEntityModels = new ConcurrentHashMap();
        this.serviceReferences = new ConcurrentHashMap();
        this.servicesReferences = new ConcurrentHashMap();
    }

    ModelModule<ObjectModel> lookupObjectModel(Class type) {
        Iterable flatten;
        ModelModule model = this.objectModels.get(type);
        if (model == null && (model = (ModelModule)Iterables.first((Iterable)(flatten = Iterables.flatten((Iterable[])new Iterable[]{TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new ExactTypeLookupSpecification(type), this.moduleInstance.visibleObjects(Visibility.module), this.moduleInstance.layerInstance().visibleObjects(Visibility.layer), this.moduleInstance.layerInstance().visibleObjects(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleObjects())), TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new AssignableTypeLookupSpecification(type), this.moduleInstance.visibleObjects(Visibility.module), this.moduleInstance.layerInstance().visibleObjects(Visibility.layer), this.moduleInstance.layerInstance().visibleObjects(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleObjects()))})))) != null) {
            this.objectModels.put(type, (ModelModule<ObjectModel>)model);
        }
        return model;
    }

    ModelModule<TransientModel> lookupTransientModel(Class type) {
        Iterable allModels;
        ModelModule model = this.transientModels.get(type);
        if (model == null && (model = (ModelModule)Iterables.first((Iterable)(allModels = Iterables.flatten((Iterable[])new Iterable[]{TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new ExactTypeLookupSpecification(type), this.moduleInstance.visibleTransients(Visibility.module), this.moduleInstance.layerInstance().visibleTransients(Visibility.layer), this.moduleInstance.layerInstance().visibleTransients(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleTransients())), TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new AssignableTypeLookupSpecification(type), this.moduleInstance.visibleTransients(Visibility.module), this.moduleInstance.layerInstance().visibleTransients(Visibility.layer), this.moduleInstance.layerInstance().visibleTransients(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleTransients()))})))) != null) {
            this.transientModels.put(type, (ModelModule<TransientModel>)model);
        }
        return model;
    }

    public ModelModule<ValueModel> lookupValueModel(Class type) {
        Iterable flatten;
        ModelModule model = this.valueModels.get(type);
        if (model == null && (model = (ModelModule)Iterables.first((Iterable)(flatten = Iterables.flatten((Iterable[])new Iterable[]{TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new ExactTypeLookupSpecification(type), this.moduleInstance.visibleValues(Visibility.module), this.moduleInstance.layerInstance().visibleValues(Visibility.layer), this.moduleInstance.layerInstance().visibleValues(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleValues())), TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new AssignableTypeLookupSpecification(type), this.moduleInstance.visibleValues(Visibility.module), this.moduleInstance.layerInstance().visibleValues(Visibility.layer), this.moduleInstance.layerInstance().visibleValues(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleValues()))})))) != null) {
            this.valueModels.put(type, (ModelModule<ValueModel>)model);
        }
        return model;
    }

    ModelModule<EntityModel> lookupEntityModel(Class type) {
        Iterable allModels;
        ModelModule model = this.unambiguousEntityModels.get(type);
        if (model == null && (model = (ModelModule)Iterables.first((Iterable)(allModels = Iterables.flatten((Iterable[])new Iterable[]{TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new ExactTypeLookupSpecification(type), this.moduleInstance.visibleEntities(Visibility.module), this.moduleInstance.layerInstance().visibleEntities(Visibility.layer), this.moduleInstance.layerInstance().visibleEntities(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleEntities())), TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new AssignableTypeLookupSpecification(type), this.moduleInstance.visibleEntities(Visibility.module), this.moduleInstance.layerInstance().visibleEntities(Visibility.layer), this.moduleInstance.layerInstance().visibleEntities(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleEntities()))})))) != null) {
            this.unambiguousEntityModels.put(type, (ModelModule<EntityModel>)model);
        }
        return model;
    }

    Iterable<ModelModule<EntityModel>> lookupEntityModels(Class type) {
        List models = this.allEntityModels.get(type);
        if (models == null) {
            Iterable matchingEntityModels = Iterables.flatten((Iterable[])new Iterable[]{TypeLookup.ambiguousTypeCheck(type, TypeLookup.findModels(new ExactTypeLookupSpecification(type), this.moduleInstance.visibleEntities(Visibility.module), this.moduleInstance.layerInstance().visibleEntities(Visibility.layer), this.moduleInstance.layerInstance().visibleEntities(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleEntities())), TypeLookup.findModels(new AssignableTypeLookupSpecification(type), this.moduleInstance.visibleEntities(Visibility.module), this.moduleInstance.layerInstance().visibleEntities(Visibility.layer), this.moduleInstance.layerInstance().visibleEntities(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleEntities())});
            matchingEntityModels = Iterables.unique((Iterable)matchingEntityModels);
            models = Iterables.toList((Iterable)matchingEntityModels);
            this.allEntityModels.put(type, models);
        }
        return models;
    }

    <T> ServiceReference<T> lookupServiceReference(Type serviceType) {
        ServiceReference serviceReference = this.serviceReferences.get(serviceType);
        if (serviceReference == null && (serviceReference = (ServiceReference)Iterables.first(this.lookupServiceReferences(serviceType))) != null) {
            this.serviceReferences.put(serviceType, serviceReference);
        }
        if (serviceReference == null) {
            throw new NoSuchServiceException(((Class)Classes.RAW_CLASS.map((Object)serviceType)).getName(), this.moduleInstance.name());
        }
        return serviceReference;
    }

    <T> Iterable<ServiceReference<T>> lookupServiceReferences(Type serviceType) {
        List serviceRefs = this.servicesReferences.get(serviceType);
        if (serviceRefs == null) {
            Iterable matchingServices = Iterables.flatten((Iterable[])new Iterable[]{TypeLookup.findServiceReferences(new ExactTypeLookupSpecification(serviceType), this.moduleInstance.visibleServices(Visibility.module), this.moduleInstance.layerInstance().visibleServices(Visibility.layer), this.moduleInstance.layerInstance().visibleServices(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleServices()), TypeLookup.findServiceReferences(new AssignableTypeLookupSpecification(serviceType), this.moduleInstance.visibleServices(Visibility.module), this.moduleInstance.layerInstance().visibleServices(Visibility.layer), this.moduleInstance.layerInstance().visibleServices(Visibility.application), this.moduleInstance.layerInstance().usedLayersInstance().visibleServices())});
            matchingServices = Iterables.unique((Iterable)matchingServices);
            serviceRefs = Iterables.toList((Iterable)matchingServices);
            this.servicesReferences.put(serviceType, serviceRefs);
        }
        return Iterables.cast(serviceRefs);
    }

    private static <T extends ModelDescriptor> Iterable<ModelModule<T>> findModels(Specification<Iterable<Class<?>>> specification, Iterable<ModelModule<T>> ... models) {
        Specification spec = Specifications.translate(new ModelModuleTypesFunction(), specification);
        Iterable flattened = Iterables.flattenIterables((Iterable)Iterables.iterable((Object[])models));
        return Iterables.filter((Specification)spec, (Iterable)flattened);
    }

    private static Iterable<ServiceReference<?>> findServiceReferences(Specification<Iterable<Class<?>>> specification, Iterable<ServiceReference<?>> ... references) {
        Specification spec = Specifications.translate((Function)new ServiceReferenceTypesFunction(), specification);
        Iterable flattened = Iterables.flattenIterables((Iterable)Iterables.iterable((Object[])references));
        return Iterables.filter((Specification)spec, (Iterable)flattened);
    }

    private static <T extends ModelDescriptor> Iterable<ModelModule<T>> ambiguousTypeCheck(final Class type, final Iterable<ModelModule<T>> models) {
        return new Iterable<ModelModule<T>>(){

            @Override
            public Iterator<ModelModule<T>> iterator() {
                ModelModule current = null;
                ArrayList<ModelModule> ambiguous = null;
                ArrayList<ModelModule> results = new ArrayList<ModelModule>();
                for (ModelModule model : models) {
                    if (current != null && !model.equals((Object)current)) {
                        if (model.model().visibility() == current.model().visibility()) {
                            if (ambiguous == null) {
                                ambiguous = new ArrayList<ModelModule>();
                            }
                            ambiguous.add(model);
                        }
                    } else {
                        current = model;
                    }
                    results.add(model);
                }
                if (ambiguous != null) {
                    ambiguous.add(current);
                    throw new AmbiguousTypeException("More than one type matches " + type.getName() + ":" + ambiguous);
                }
                return results.iterator();
            }
        };
    }

    private static final class AssignableTypeLookupSpecification
    extends AbstractTypeLookupSpecification {
        private AssignableTypeLookupSpecification(Type lookedupType) {
            super(lookedupType);
        }

        @Override
        protected boolean checkClassMatch(Class<?> candidate, Class<?> lookedUpType) {
            return !candidate.equals(lookedUpType) && lookedUpType.isAssignableFrom(candidate);
        }
    }

    private static final class ExactTypeLookupSpecification
    extends AbstractTypeLookupSpecification {
        private ExactTypeLookupSpecification(Type lookedupType) {
            super(lookedupType);
        }

        @Override
        protected boolean checkClassMatch(Class<?> candidate, Class<?> lookedUpType) {
            return candidate.equals(lookedUpType);
        }
    }

    private static abstract class AbstractTypeLookupSpecification
    implements Specification<Iterable<Class<?>>> {
        protected final Type lookedUpType;

        private AbstractTypeLookupSpecification(Type lookedUpType) {
            this.lookedUpType = lookedUpType;
        }

        public final boolean satisfiedBy(Iterable<Class<?>> types) {
            if (this.lookedUpType instanceof Class) {
                return this.checkClassMatch(types, (Class)this.lookedUpType);
            }
            if (this.lookedUpType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)this.lookedUpType;
                if (!this.checkClassMatch(types, (Class)parameterizedType.getRawType())) {
                    return false;
                }
                for (Type intf : Classes.interfacesOf(types)) {
                    if (!intf.equals(this.lookedUpType)) continue;
                    return true;
                }
                return false;
            }
            return this.lookedUpType instanceof WildcardType;
        }

        private boolean checkClassMatch(Iterable<Class<?>> candidates, Class<?> lookedUpType) {
            for (Class<?> candidate : candidates) {
                if (!this.checkClassMatch(candidate, lookedUpType)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean checkClassMatch(Class<?> var1, Class<?> var2);
    }

    private static class ServiceReferenceTypesFunction
    implements Function<ServiceReference<?>, Iterable<Class<?>>> {
        private ServiceReferenceTypesFunction() {
        }

        public Iterable<Class<?>> map(ServiceReference<?> serviceReference) {
            return serviceReference.types();
        }
    }

    private static class ModelModuleTypesFunction<T extends ModelDescriptor>
    implements Function<ModelModule<T>, Iterable<Class<?>>> {
        private ModelModuleTypesFunction() {
        }

        public Iterable<Class<?>> map(ModelModule<T> modelModule) {
            return modelModule.model().types();
        }
    }
}

