/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.unitofwork;

import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.util.Classes;
import org.qi4j.runtime.unitofwork.BuilderManyAssociationState;
import org.qi4j.runtime.unitofwork.BuilderNamedAssociationState;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entity.NamedAssociationState;

public final class BuilderEntityState
implements EntityState {
    private final EntityDescriptor entityType;
    private final EntityReference reference;
    private final Map<QualifiedName, Object> properties = new HashMap<QualifiedName, Object>();
    private final Map<QualifiedName, EntityReference> associations = new HashMap<QualifiedName, EntityReference>();
    private final Map<QualifiedName, ManyAssociationState> manyAssociations = new HashMap<QualifiedName, ManyAssociationState>();
    private final Map<QualifiedName, NamedAssociationState> namedAssociations = new HashMap<QualifiedName, NamedAssociationState>();

    public BuilderEntityState(EntityDescriptor type, EntityReference reference) {
        this.entityType = type;
        this.reference = reference;
    }

    public EntityReference identity() {
        return this.reference;
    }

    public String version() {
        return "";
    }

    public long lastModified() {
        return 0L;
    }

    public void remove() {
    }

    public EntityStatus status() {
        return EntityStatus.NEW;
    }

    public boolean isAssignableTo(Class<?> type) {
        return Classes.exactTypeSpecification(type).satisfiedBy((Object)this.entityType);
    }

    public EntityDescriptor entityDescriptor() {
        return this.entityType;
    }

    public Object propertyValueOf(QualifiedName stateName) {
        return this.properties.get(stateName);
    }

    public EntityReference associationValueOf(QualifiedName stateName) {
        return this.associations.get(stateName);
    }

    public void setPropertyValue(QualifiedName stateName, Object newValue) {
        this.properties.put(stateName, newValue);
    }

    public void setAssociationValue(QualifiedName stateName, EntityReference newEntity) {
        this.associations.put(stateName, newEntity);
    }

    public ManyAssociationState manyAssociationValueOf(QualifiedName stateName) {
        ManyAssociationState state = this.manyAssociations.get(stateName);
        if (state == null) {
            state = new BuilderManyAssociationState();
            this.manyAssociations.put(stateName, state);
        }
        return state;
    }

    public NamedAssociationState namedAssociationValueOf(QualifiedName stateName) {
        NamedAssociationState state = this.namedAssociations.get(stateName);
        if (state == null) {
            state = new BuilderNamedAssociationState();
            this.namedAssociations.put(stateName, state);
        }
        return state;
    }

    public void copyTo(EntityState newEntityState) {
        QualifiedName qName;
        for (Map.Entry<QualifiedName, Object> entry : this.properties.entrySet()) {
            newEntityState.setPropertyValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<QualifiedName, Object> entry : this.associations.entrySet()) {
            newEntityState.setAssociationValue(entry.getKey(), (EntityReference)entry.getValue());
        }
        for (Map.Entry<QualifiedName, Object> entry : this.manyAssociations.entrySet()) {
            qName = entry.getKey();
            ManyAssociationState fromManyAssoc = (ManyAssociationState)entry.getValue();
            ManyAssociationState toManyAssoc = newEntityState.manyAssociationValueOf(qName);
            for (EntityReference entityReference : fromManyAssoc) {
                toManyAssoc.add(0, entityReference);
            }
        }
        for (Map.Entry<QualifiedName, Object> entry : this.namedAssociations.entrySet()) {
            qName = entry.getKey();
            NamedAssociationState fromNamedAssoc = (NamedAssociationState)entry.getValue();
            NamedAssociationState toNamedAssoc = newEntityState.namedAssociationValueOf(qName);
            for (String name : fromNamedAssoc) {
                toNamedAssoc.put(name, fromNamedAssoc.get(name));
            }
        }
    }
}

