/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.unitofwork;

import java.lang.reflect.AccessibleObject;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.entity.LifecycleException;
import org.qi4j.runtime.composite.FunctionStateResolver;
import org.qi4j.runtime.entity.EntityInstance;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.runtime.unitofwork.BuilderEntityState;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.module.ModelModule;

public final class EntityBuilderInstance<T>
implements EntityBuilder<T> {
    private static final QualifiedName IDENTITY_STATE_NAME;
    private final ModelModule<EntityModel> model;
    private final ModuleUnitOfWork uow;
    private final EntityStoreUnitOfWork store;
    private String identity;
    private final BuilderEntityState entityState;
    private final EntityInstance prototypeInstance;

    public EntityBuilderInstance(ModelModule<EntityModel> model, ModuleUnitOfWork uow, EntityStoreUnitOfWork store, String identity) {
        this(model, uow, store, identity, null);
    }

    public EntityBuilderInstance(ModelModule<EntityModel> model, ModuleUnitOfWork uow, EntityStoreUnitOfWork store, String identity, FunctionStateResolver stateResolver) {
        this.model = model;
        this.uow = uow;
        this.store = store;
        this.identity = identity;
        EntityReference reference = new EntityReference(identity);
        this.entityState = new BuilderEntityState((EntityDescriptor)model.model(), reference);
        ((EntityModel)model.model()).initState(model.module(), this.entityState);
        if (stateResolver != null) {
            stateResolver.populateState((EntityModel)model.model(), this.entityState);
        }
        this.entityState.setPropertyValue(IDENTITY_STATE_NAME, identity);
        this.prototypeInstance = ((EntityModel)model.model()).newInstance(uow, model.module(), this.entityState);
    }

    public T instance() {
        this.checkValid();
        return this.prototypeInstance.proxy();
    }

    public <K> K instanceFor(Class<K> mixinType) {
        this.checkValid();
        return this.prototypeInstance.newProxy(mixinType);
    }

    public T newInstance() throws LifecycleException {
        this.checkValid();
        String identity = (String)this.entityState.propertyValueOf(IDENTITY_STATE_NAME);
        EntityState newEntityState = ((EntityModel)this.model.model()).newEntityState(this.store, this.uow.module(), EntityReference.parseEntityReference((String)identity));
        this.prototypeInstance.invokeCreate();
        this.prototypeInstance.checkConstraints();
        this.entityState.copyTo(newEntityState);
        EntityInstance instance = ((EntityModel)this.model.model()).newInstance(this.uow, this.model.module(), newEntityState);
        Object proxy = instance.proxy();
        this.uow.addEntity(instance);
        this.identity = null;
        return proxy;
    }

    private void checkValid() throws IllegalStateException {
        if (this.identity == null) {
            throw new IllegalStateException("EntityBuilder is not valid after call to newInstance()");
        }
    }

    static {
        try {
            IDENTITY_STATE_NAME = QualifiedName.fromAccessor((AccessibleObject)Identity.class.getMethod("identity", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Zest Core Runtime codebase is corrupted. Contact Zest team: EntityBuilderInstance");
        }
    }
}

