/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.unitofwork;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.metrics.MetricsCounter;
import org.qi4j.api.metrics.MetricsCounterFactory;
import org.qi4j.api.metrics.MetricsProvider;
import org.qi4j.api.metrics.MetricsTimer;
import org.qi4j.api.metrics.MetricsTimerFactory;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWorkCallback;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkException;
import org.qi4j.api.unitofwork.UnitOfWorkOptions;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.entity.EntityInstance;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.ConcurrentEntityStateModificationException;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.metrics.DefaultMetric;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;

public final class UnitOfWorkInstance {
    private static final ThreadLocal<Stack<UnitOfWorkInstance>> current = new ThreadLocal<Stack<UnitOfWorkInstance>>(){

        @Override
        protected Stack<UnitOfWorkInstance> initialValue() {
            return new Stack<UnitOfWorkInstance>();
        }
    };
    private MetricsTimer.Context metricsTimer;
    private long currentTime;
    private MetricsProvider metrics;
    final HashMap<EntityReference, EntityInstance> instanceCache;
    final HashMap<EntityStore, EntityStoreUnitOfWork> storeUnitOfWork;
    private boolean open;
    private boolean paused;
    private Usecase usecase;
    private MetaInfo metaInfo;
    private List<UnitOfWorkCallback> callbacks;

    public static Stack<UnitOfWorkInstance> getCurrent() {
        return current.get();
    }

    public UnitOfWorkInstance(Usecase usecase, long currentTime, MetricsProvider metrics) {
        this.currentTime = currentTime;
        this.open = true;
        this.instanceCache = new HashMap();
        this.storeUnitOfWork = new HashMap();
        UnitOfWorkInstance.getCurrent().push(this);
        this.paused = false;
        this.usecase = usecase;
        this.startCapture(metrics);
    }

    public long currentTime() {
        return this.currentTime;
    }

    public EntityStoreUnitOfWork getEntityStoreUnitOfWork(EntityStore store, ModuleSpi module) {
        EntityStoreUnitOfWork uow = this.storeUnitOfWork.get(store);
        if (uow == null) {
            uow = store.newUnitOfWork(this.usecase, module, this.currentTime);
            this.storeUnitOfWork.put(store, uow);
        }
        return uow;
    }

    public <T> T get(EntityReference identity, ModuleUnitOfWork uow, Iterable<ModelModule<EntityModel>> potentialModels, Class<T> mixinType) throws EntityTypeNotFoundException, NoSuchEntityException {
        this.checkOpen();
        EntityInstance entityInstance = this.instanceCache.get(identity);
        if (entityInstance == null) {
            EntityState entityState = null;
            EntityModel model = null;
            ModuleSpi module = null;
            for (ModelModule<EntityModel> potentialModel : potentialModels) {
                EntityStore store = potentialModel.module().entityStore();
                EntityStoreUnitOfWork storeUow = this.getEntityStoreUnitOfWork(store, potentialModel.module());
                try {
                    entityState = storeUow.entityStateOf(potentialModel.module(), identity);
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                model = (EntityModel)entityState.entityDescriptor();
                module = potentialModel.module();
            }
            if (model == null) {
                if (entityState == null) {
                    throw new NoSuchEntityException(identity, mixinType, this.usecase);
                }
                throw new EntityTypeNotFoundException(mixinType.getName(), module.name(), Iterables.map((Function)ModelModule.toStringFunction, (Iterable)module.findVisibleEntityTypes()));
            }
            entityInstance = new EntityInstance(uow, module, model, entityState);
            this.instanceCache.put(identity, entityInstance);
        } else if (entityInstance.status() == EntityStatus.REMOVED) {
            throw new NoSuchEntityException(identity, mixinType, this.usecase);
        }
        return entityInstance.proxy();
    }

    public Usecase usecase() {
        return this.usecase;
    }

    public MetaInfo metaInfo() {
        if (this.metaInfo == null) {
            this.metaInfo = new MetaInfo();
        }
        return this.metaInfo;
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
            UnitOfWorkInstance.getCurrent().pop();
            UnitOfWorkOptions unitOfWorkOptions = (UnitOfWorkOptions)this.metaInfo().get(UnitOfWorkOptions.class);
            if (unitOfWorkOptions == null) {
                unitOfWorkOptions = (UnitOfWorkOptions)this.usecase().metaInfo(UnitOfWorkOptions.class);
            }
            if (unitOfWorkOptions != null && unitOfWorkOptions.isPruneOnPause()) {
                ArrayList<EntityReference> prunedInstances = null;
                for (EntityInstance entityInstance : this.instanceCache.values()) {
                    if (entityInstance.status() != EntityStatus.LOADED) continue;
                    if (prunedInstances == null) {
                        prunedInstances = new ArrayList<EntityReference>();
                    }
                    prunedInstances.add(entityInstance.identity());
                }
                if (prunedInstances != null) {
                    for (EntityReference prunedInstance : prunedInstances) {
                        this.instanceCache.remove(prunedInstance);
                    }
                }
            }
        } else {
            throw new UnitOfWorkException("Unit of work is not active");
        }
    }

    public void resume() {
        if (!this.paused) {
            throw new UnitOfWorkException("Unit of work has not been paused");
        }
        this.paused = false;
        UnitOfWorkInstance.getCurrent().push(this);
    }

    public void complete() throws UnitOfWorkCompletionException {
        this.checkOpen();
        ArrayList<UnitOfWorkCallback> currentCallbacks = this.callbacks == null ? null : new ArrayList<UnitOfWorkCallback>(this.callbacks);
        List<StateCommitter> committers = this.applyChanges();
        this.notifyBeforeCompletion(currentCallbacks);
        for (StateCommitter committer : committers) {
            committer.commit();
        }
        this.close();
        this.notifyAfterCompletion(currentCallbacks, UnitOfWorkCallback.UnitOfWorkStatus.COMPLETED);
        this.callbacks = currentCallbacks;
    }

    public void discard() {
        if (!this.isOpen()) {
            return;
        }
        this.close();
        ArrayList<UnitOfWorkCallback> currentCallbacks = this.callbacks == null ? null : new ArrayList<UnitOfWorkCallback>(this.callbacks);
        this.notifyAfterCompletion(currentCallbacks, UnitOfWorkCallback.UnitOfWorkStatus.DISCARDED);
        for (EntityStoreUnitOfWork entityStoreUnitOfWork : this.storeUnitOfWork.values()) {
            entityStoreUnitOfWork.discard();
        }
        this.callbacks = currentCallbacks;
    }

    private void close() {
        this.checkOpen();
        if (!this.isPaused()) {
            UnitOfWorkInstance.getCurrent().pop();
        }
        this.endCapture();
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void addUnitOfWorkCallback(UnitOfWorkCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<UnitOfWorkCallback>();
        }
        this.callbacks.add(callback);
    }

    public void removeUnitOfWorkCallback(UnitOfWorkCallback callback) {
        if (this.callbacks != null) {
            this.callbacks.remove(callback);
        }
    }

    public void addEntity(EntityInstance instance) {
        this.instanceCache.put(instance.identity(), instance);
    }

    private List<StateCommitter> applyChanges() throws UnitOfWorkCompletionException {
        ArrayList<StateCommitter> committers = new ArrayList<StateCommitter>();
        for (EntityStoreUnitOfWork entityStoreUnitOfWork : this.storeUnitOfWork.values()) {
            try {
                StateCommitter committer = entityStoreUnitOfWork.applyChanges();
                committers.add(committer);
            }
            catch (Exception e) {
                for (StateCommitter committer : committers) {
                    committer.cancel();
                }
                if (e instanceof ConcurrentEntityStateModificationException) {
                    ConcurrentEntityStateModificationException mee = (ConcurrentEntityStateModificationException)e;
                    Collection modifiedEntityIdentities = mee.modifiedEntities();
                    ArrayList modifiedEntities = new ArrayList();
                    for (EntityReference modifiedEntityIdentity : modifiedEntityIdentities) {
                        Collection<EntityInstance> instances = this.instanceCache.values();
                        for (EntityInstance instance : instances) {
                            if (!instance.identity().equals((Object)modifiedEntityIdentity)) continue;
                            modifiedEntities.add(instance.proxy());
                        }
                    }
                    throw new ConcurrentEntityModificationException(modifiedEntities);
                }
                throw new UnitOfWorkCompletionException((Throwable)e);
            }
        }
        return committers;
    }

    private void notifyBeforeCompletion(List<UnitOfWorkCallback> callbacks) throws UnitOfWorkCompletionException {
        if (callbacks != null) {
            for (UnitOfWorkCallback callback : callbacks) {
                callback.beforeCompletion();
            }
        }
        try {
            for (EntityInstance instance : this.instanceCache.values()) {
                boolean isNotRemoved;
                boolean isCallback = instance.proxy() instanceof UnitOfWorkCallback;
                boolean bl = isNotRemoved = !instance.status().equals((Object)EntityStatus.REMOVED);
                if (!isCallback || !isNotRemoved) continue;
                UnitOfWorkCallback callback = (UnitOfWorkCallback)UnitOfWorkCallback.class.cast(instance.proxy());
                callback.beforeCompletion();
            }
        }
        catch (UnitOfWorkCompletionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnitOfWorkCompletionException((Throwable)e);
        }
    }

    private void notifyAfterCompletion(List<UnitOfWorkCallback> callbacks, UnitOfWorkCallback.UnitOfWorkStatus status) {
        if (callbacks != null) {
            for (UnitOfWorkCallback callback : callbacks) {
                try {
                    callback.afterCompletion(status);
                }
                catch (Exception e) {}
            }
        }
        try {
            for (EntityInstance instance : this.instanceCache.values()) {
                boolean isNotRemoved;
                boolean isCallback = instance.proxy() instanceof UnitOfWorkCallback;
                boolean bl = isNotRemoved = !instance.status().equals((Object)EntityStatus.REMOVED);
                if (!isCallback || !isNotRemoved) continue;
                UnitOfWorkCallback callback = (UnitOfWorkCallback)UnitOfWorkCallback.class.cast(instance.proxy());
                callback.afterCompletion(status);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkOpen() {
        if (!this.isOpen()) {
            throw new UnitOfWorkException("Unit of work has been closed");
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String toString() {
        return "UnitOfWork " + this.hashCode() + "(" + this.usecase + "): entities:" + this.instanceCache.size();
    }

    public void remove(EntityReference entityReference) {
        this.instanceCache.remove(entityReference);
    }

    private void incrementCount() {
        MetricsCounter counter = this.getCounter();
        counter.increment();
    }

    private void decrementCount() {
        MetricsCounter counter = this.getCounter();
        counter.decrement();
    }

    private MetricsCounter getCounter() {
        if (this.metrics != null) {
            MetricsCounterFactory metricsFactory = (MetricsCounterFactory)this.metrics.createFactory(MetricsCounterFactory.class);
            return metricsFactory.createCounter(this.getClass(), "UnitOfWork Counter");
        }
        return new DefaultMetric();
    }

    private void endCapture() {
        this.decrementCount();
        this.metricsTimer.stop();
    }

    private void startCapture(MetricsProvider metrics) {
        this.metrics = metrics;
        this.incrementCount();
        this.startTimer(metrics);
    }

    private void startTimer(MetricsProvider metrics) {
        MetricsTimerFactory metricsFactory = (MetricsTimerFactory)metrics.createFactory(MetricsTimerFactory.class);
        String name = "UnitOfWork Timer";
        MetricsTimer timer = metricsFactory.createTimer(this.getClass(), name, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        this.metricsTimer = timer.start();
    }
}

