/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import org.eclipse.jetty.server.Server;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.importer.InstanceImporter;
import org.qi4j.bootstrap.Assemblers;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ImportedServiceDeclaration;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.bootstrap.ServiceDeclaration;
import org.qi4j.library.http.JettyConfiguration;
import org.qi4j.library.http.JettyService;

public class JettyServiceAssembler
extends Assemblers.VisibilityIdentityConfig<JettyServiceAssembler> {
    protected ModuleAssembly serverModule;
    protected Visibility serverVisibility = Visibility.module;
    protected String serverIdentity;

    public JettyServiceAssembler withServer(ModuleAssembly serverModule, Visibility serverVisibility) {
        this.serverModule = serverModule;
        this.serverVisibility = serverVisibility;
        return this;
    }

    public JettyServiceAssembler serverIdentifiedBy(String serverIdentity) {
        this.serverIdentity = serverIdentity;
        return this;
    }

    public final void assemble(ModuleAssembly module) throws AssemblyException {
        ServiceDeclaration service = module.services(new Class[]{this.httpService()}).visibleIn(this.visibility()).instantiateOnStartup();
        if (this.hasIdentity()) {
            service.identifiedBy(this.identity());
        }
        if (this.hasConfig()) {
            this.configModule().entities(new Class[]{this.configurationEntity()}).visibleIn(this.configVisibility());
        }
        this.assembleServer(module);
    }

    protected final void assembleServer(ModuleAssembly module) {
        this.serverModule = this.serverModule != null ? this.serverModule : module;
        ImportedServiceDeclaration server = this.serverModule.importedServices(new Class[]{Server.class}).importedBy(InstanceImporter.class).setMetaInfo((Object)new Server()).visibleIn(this.serverVisibility);
        if (this.serverIdentity != null) {
            server.identifiedBy(this.serverIdentity);
        }
    }

    protected Class<? extends JettyConfiguration> configurationEntity() {
        return JettyConfiguration.class;
    }

    protected Class<? extends JettyService> httpService() {
        return JettyService.class;
    }
}

