/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.valueserialization.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.value.ValueDeserializer;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.functional.Function;
import org.qi4j.spi.value.ValueDeserializerAdapter;

public class JacksonValueDeserializer
extends ValueDeserializerAdapter<JsonParser, JsonNode> {
    private final JsonFactory jsonFactory = new MappingJsonFactory();

    public JacksonValueDeserializer(@Structure Application application, @Structure Module module, @Service ServiceReference<ValueDeserializer> serviceRef) {
        super(application, module, serviceRef);
    }

    protected JsonParser adaptInput(InputStream input) throws Exception {
        return this.jsonFactory.createParser(input);
    }

    protected void onDeserializationEnd(ValueType valueType, JsonParser input) throws Exception {
        input.close();
    }

    protected Object readPlainValue(JsonParser input) throws Exception {
        JsonNode jsonNode = (JsonNode)input.readValueAsTree();
        if (jsonNode.isArray() || jsonNode.isObject()) {
            throw new ValueSerializationException("Asked for a Value but found an Object or an Array at " + input.getCurrentLocation().toString());
        }
        if (jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isLong()) {
            return jsonNode.asLong();
        }
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isNull()) {
            return null;
        }
        return jsonNode.asText();
    }

    protected <T> Collection<T> readArrayInCollection(JsonParser input, Function<JsonParser, T> deserializer, Collection<T> collection) throws Exception {
        JsonToken token = input.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.START_ARRAY) {
            token = input.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.START_ARRAY) {
            throw new ValueSerializationException("Expected an array start at " + input.getCurrentLocation().toString());
        }
        while (input.nextToken() != JsonToken.END_ARRAY) {
            Object element = deserializer.map((Object)input);
            collection.add(element);
        }
        return collection;
    }

    protected <K, V> Map<K, V> readMapInMap(JsonParser input, Function<JsonParser, K> keyDeserializer, Function<JsonParser, V> valueDeserializer, Map<K, V> map) throws Exception {
        JsonToken token = input.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.START_ARRAY) {
            token = input.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.START_ARRAY) {
            throw new ValueSerializationException("Expected an array start at " + input.getCurrentLocation().toString());
        }
        JsonToken currentToken = input.nextToken();
        while (currentToken != JsonToken.END_ARRAY) {
            if (currentToken != JsonToken.START_OBJECT) {
                throw new ValueSerializationException("Expected an object start at " + input.getCurrentLocation().toString());
            }
            currentToken = input.nextToken();
            Object key = null;
            Object value = null;
            while (currentToken != JsonToken.END_OBJECT) {
                String objectKey = input.getCurrentName();
                input.nextToken();
                if ("key".equals(objectKey)) {
                    key = keyDeserializer.map((Object)input);
                } else if ("value".equals(objectKey)) {
                    value = valueDeserializer.map((Object)input);
                } else {
                    input.skipChildren();
                }
                currentToken = input.nextToken();
            }
            if (key != null) {
                map.put(key, value);
            }
            currentToken = input.nextToken();
        }
        return map;
    }

    protected ObjectNode readObjectTree(JsonParser input) throws Exception {
        JsonToken token = input.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.START_OBJECT) {
            token = input.nextToken();
        }
        if (token != JsonToken.START_OBJECT) {
            throw new ValueSerializationException("Expected an object start at " + input.getCurrentLocation().toString());
        }
        return (ObjectNode)input.readValueAsTree();
    }

    protected Object asSimpleValue(JsonNode inputNode) throws Exception {
        if (JacksonValueDeserializer.isNullOrMissing(inputNode)) {
            return null;
        }
        if (!inputNode.isValueNode()) {
            throw new ValueSerializationException("Expected a value node but got a container node " + inputNode);
        }
        if (inputNode.isDouble()) {
            return inputNode.asDouble();
        }
        if (inputNode.isLong()) {
            return inputNode.asLong();
        }
        if (inputNode.isInt()) {
            return inputNode.asInt();
        }
        if (inputNode.isBoolean()) {
            return inputNode.asBoolean();
        }
        return inputNode.asText();
    }

    protected boolean isObjectValue(JsonNode inputNode) throws Exception {
        if (JacksonValueDeserializer.isNullOrMissing(inputNode)) {
            return false;
        }
        return inputNode.isObject();
    }

    protected boolean objectHasField(JsonNode inputNode, String key) throws Exception {
        if (JacksonValueDeserializer.isNullOrMissing(inputNode)) {
            return false;
        }
        if (!inputNode.isObject()) {
            throw new ValueSerializationException("Expected an object but got " + inputNode);
        }
        return inputNode.has(key);
    }

    protected <T> T getObjectFieldValue(JsonNode inputNode, String key, Function<JsonNode, T> valueDeserializer) throws Exception {
        JsonNode valueNode = inputNode.get(key);
        if (JacksonValueDeserializer.isNullOrMissing(valueNode)) {
            return null;
        }
        Object value = valueDeserializer.map((Object)valueNode);
        return (T)value;
    }

    protected <T> void putArrayNodeInCollection(JsonNode inputNode, Function<JsonNode, T> deserializer, Collection<T> collection) throws Exception {
        if (JacksonValueDeserializer.isNullOrMissing(inputNode)) {
            return;
        }
        if (!inputNode.isArray()) {
            throw new ValueSerializationException("Expected an array but got " + inputNode);
        }
        ArrayNode array = (ArrayNode)inputNode;
        for (JsonNode item : array) {
            Object value = deserializer.map((Object)item);
            collection.add(value);
        }
    }

    protected <K, V> void putArrayNodeInMap(JsonNode inputNode, Function<JsonNode, K> keyDeserializer, Function<JsonNode, V> valueDeserializer, Map<K, V> map) throws Exception {
        if (JacksonValueDeserializer.isNullOrMissing(inputNode)) {
            return;
        }
        if (!inputNode.isArray()) {
            throw new ValueSerializationException("Expected an array but got " + inputNode);
        }
        ArrayNode array = (ArrayNode)inputNode;
        for (JsonNode item : array) {
            if (!item.isObject()) {
                throw new ValueSerializationException("Expected an object but got " + inputNode);
            }
            JsonNode keyNode = item.get("key");
            JsonNode valueNode = item.get("value");
            Object key = keyDeserializer.map((Object)keyNode);
            Object value = valueDeserializer.map((Object)valueNode);
            if (key == null) continue;
            map.put(key, value);
        }
    }

    protected <V> void putObjectNodeInMap(JsonNode inputNode, Function<JsonNode, V> valueDeserializer, Map<String, V> map) throws Exception {
        if (JacksonValueDeserializer.isNullOrMissing(inputNode)) {
            return;
        }
        if (!inputNode.isObject()) {
            throw new ValueSerializationException("Expected an object but got " + inputNode);
        }
        ObjectNode object = (ObjectNode)inputNode;
        Iterator fields = object.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            Object value = valueDeserializer.map(entry.getValue());
            map.put((String)entry.getKey(), value);
        }
    }

    private static boolean isNullOrMissing(JsonNode inputNode) {
        return inputNode == null || inputNode.isNull() || inputNode.isMissingNode();
    }
}

