/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.valueserialization.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.OutputStream;
import org.qi4j.spi.value.ValueSerializerAdapter;

public class JacksonValueSerializer
extends ValueSerializerAdapter<JsonGenerator> {
    private final JsonFactory jsonFactory = new MappingJsonFactory();

    protected JsonGenerator adaptOutput(OutputStream output) throws Exception {
        return this.jsonFactory.createGenerator(output);
    }

    protected void onSerializationEnd(Object object, JsonGenerator output) throws Exception {
        output.close();
    }

    protected void onArrayStart(JsonGenerator output) throws Exception {
        output.writeStartArray();
    }

    protected void onArrayEnd(JsonGenerator output) throws Exception {
        output.writeEndArray();
    }

    protected void onObjectStart(JsonGenerator output) throws Exception {
        output.writeStartObject();
    }

    protected void onObjectEnd(JsonGenerator output) throws Exception {
        output.writeEndObject();
    }

    protected void onFieldStart(JsonGenerator output, String fieldName) throws Exception {
        output.writeFieldName(fieldName);
    }

    protected void onValue(JsonGenerator output, Object value) throws Exception {
        output.writeObject(value);
    }
}

