/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.debug.service;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.injection.scope.Invocation;
import org.qi4j.api.sideeffect.SideEffectOf;
import org.qi4j.functional.Iterables;
import org.qi4j.logging.debug.service.DebuggingService;
import org.qi4j.logging.log.service.LoggingService;

public class DebugOnConsoleSideEffect
extends SideEffectOf<LoggingService>
implements DebuggingService {
    private static PrintStream OUT = System.err;
    private final ResourceBundle bundle;

    public DebugOnConsoleSideEffect(@Invocation Method thisMethod) {
        this.bundle = ResourceBundle.getBundle(thisMethod.getDeclaringClass().getName());
    }

    @Override
    public int debugLevel() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void debug(Composite composite, String message) {
        String localized = this.bundle.getString(message);
        OUT.println("DEBUG:" + this.getCompositeName(composite) + ": " + localized);
    }

    private String getCompositeName(Composite composite) {
        return ((Class)Iterables.first((Iterable)((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)composite)).types())).getName();
    }

    @Override
    public void debug(Composite composite, String message, Serializable param1) {
        String localized = this.bundle.getString(message);
        String formatted = MessageFormat.format(localized, param1);
        OUT.println("DEBUG:" + this.getCompositeName(composite) + ": " + formatted);
        if (param1 instanceof Throwable) {
            this.handleException((Throwable)param1);
        }
    }

    @Override
    public void debug(Composite composite, String message, Serializable param1, Serializable param2) {
        String localized = this.bundle.getString(message);
        String formatted = MessageFormat.format(localized, param1, param2);
        OUT.println("DEBUG:" + this.getCompositeName(composite) + ": " + formatted);
        if (param1 instanceof Throwable) {
            this.handleException((Throwable)param1);
        }
    }

    @Override
    public void debug(Composite composite, String message, Serializable ... params) {
        String localized = this.bundle.getString(message);
        String formatted = MessageFormat.format(localized, new Object[]{params});
        OUT.println("DEBUG:" + this.getCompositeName(composite) + ": " + formatted);
        if (params[0] instanceof Throwable) {
            this.handleException((Throwable)params[0]);
        }
    }

    private void handleException(Throwable exception) {
        if (exception != null) {
            exception.printStackTrace(OUT);
        }
    }
}

