/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.log.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.functional.Iterables;
import org.qi4j.logging.log.LogType;
import org.qi4j.logging.log.records.CompositeLogRecord;
import org.qi4j.logging.log.records.EntityLogRecord;
import org.qi4j.logging.log.records.LogRecord;
import org.qi4j.logging.log.records.ServiceLogRecord;
import org.qi4j.logging.log.service.LoggingService;

public abstract class LoggingServiceMixin
implements LoggingService {
    @Structure
    private UnitOfWorkFactory uowf;

    public void log(LogType type, Composite composite, String category, String message) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>();
            this.createLogRecord(uow, type, composite, category, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    public void log(LogType type, Composite composite, String category, String message, Serializable param1) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>();
            paramsList.add(param1);
            this.createLogRecord(uow, type, composite, category, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    public void log(LogType type, Composite composite, String category, String message, Serializable param1, Serializable param2) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>();
            paramsList.add(param1);
            paramsList.add(param2);
            this.createLogRecord(uow, type, composite, category, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    @Override
    public void log(LogType type, Composite composite, String category, String message, Serializable ... params) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>(Arrays.asList(params));
            this.createLogRecord(uow, type, composite, category, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    private void createLogRecord(UnitOfWork uow, LogType type, Composite composite, String category, String message, List<Serializable> params) {
        if (composite instanceof ServiceComposite) {
            EntityBuilder builder = uow.newEntityBuilder(ServiceLogRecord.class);
            ServiceLogRecord state = (ServiceLogRecord)builder.instance();
            this.setStandardStuff(type, composite, category, message, state, params);
            state.source().set(((ServiceComposite)composite).identity().get());
            ServiceLogRecord slr = (ServiceLogRecord)builder.newInstance();
        } else if (composite instanceof EntityComposite) {
            EntityBuilder builder = uow.newEntityBuilder(EntityLogRecord.class);
            EntityLogRecord state = (EntityLogRecord)builder.instance();
            this.setStandardStuff(type, composite, category, message, state, params);
            state.source().set((Object)((EntityComposite)composite));
            EntityLogRecord elr = (EntityLogRecord)builder.newInstance();
        } else {
            EntityBuilder builder = uow.newEntityBuilder(CompositeLogRecord.class);
            CompositeLogRecord state = (CompositeLogRecord)builder.instance();
            this.setStandardStuff(type, composite, category, message, state, params);
            state.source().set((Object)composite);
            CompositeLogRecord clr = (CompositeLogRecord)builder.newInstance();
        }
    }

    private void setStandardStuff(LogType type, Composite composite, String category, String message, LogRecord state, List<Serializable> params) {
        state.logtype().set((Object)type);
        state.time().set((Object)System.currentTimeMillis());
        state.category().set((Object)category);
        state.message().set((Object)message);
        state.compositeTypeName().set((Object)this.getCompositeName(composite));
        state.threadName().set((Object)Thread.currentThread().getName());
        state.parameters().set(params);
    }

    private String getCompositeName(Composite composite) {
        return ((Class)Iterables.first((Iterable)((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)composite)).types())).getName();
    }
}

