/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.indexing;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Iterables;
import org.qi4j.library.rdf.entity.EntityStateSerializer;
import org.qi4j.library.rdf.entity.EntityTypeSerializer;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.StateChangeListener;

@Mixins(value={RdfEntityIndexerMixin.class})
@Activators(value={Activator.class})
public interface RdfIndexingService
extends StateChangeListener {
    public void initialize();

    public File dataDir();

    public static abstract class RdfEntityIndexerMixin
    implements RdfIndexingService {
        @Service
        private ServiceReference<Repository> repository;
        @Uses
        private EntityStateSerializer stateSerializer;
        @Uses
        private EntityTypeSerializer typeSerializer;
        private Set<EntityDescriptor> indexedEntityTypes;
        private ValueFactory valueFactory;

        @Override
        public void initialize() {
            this.indexedEntityTypes = new HashSet<EntityDescriptor>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanges(Iterable<EntityState> entityStates) {
            try {
                if (this.repository == null || !this.repository.isActive()) {
                    return;
                }
                RepositoryConnection connection = ((Repository)this.repository.get()).getConnection();
                if (connection == null) {
                    return;
                }
                connection.setAutoCommit(false);
                try {
                    this.removeEntityStates(entityStates, connection);
                    connection.commit();
                    Set<EntityDescriptor> entityTypes = this.indexUpdates(entityStates, connection);
                    this.indexNewTypes(connection, entityTypes);
                }
                finally {
                    connection.commit();
                    connection.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void indexNewTypes(RepositoryConnection connection, Set<EntityDescriptor> entityTypes) throws RepositoryException {
            for (EntityDescriptor entityType : entityTypes) {
                if (this.indexedEntityTypes.contains(entityType)) continue;
                this.indexEntityType(entityType, connection);
                this.indexedEntityTypes.add(entityType);
            }
        }

        private Set<EntityDescriptor> indexUpdates(Iterable<EntityState> entityStates, RepositoryConnection connection) throws RepositoryException {
            HashSet<EntityDescriptor> entityTypes = new HashSet<EntityDescriptor>();
            for (EntityState entityState : entityStates) {
                if (entityState.status().equals((Object)EntityStatus.UPDATED)) {
                    this.indexEntityState(entityState, connection);
                    entityTypes.add(entityState.entityDescriptor());
                    continue;
                }
                if (!entityState.status().equals((Object)EntityStatus.NEW)) continue;
                this.indexEntityState(entityState, connection);
                entityTypes.add(entityState.entityDescriptor());
            }
            return entityTypes;
        }

        private void removeEntityStates(Iterable<EntityState> entityStates, RepositoryConnection connection) throws RepositoryException {
            ArrayList<URI> removedStates = new ArrayList<URI>();
            for (EntityState entityState : entityStates) {
                if (entityState.status().equals((Object)EntityStatus.REMOVED)) {
                    removedStates.add(this.stateSerializer.createEntityURI(this.getValueFactory(), entityState.identity()));
                    continue;
                }
                if (!entityState.status().equals((Object)EntityStatus.UPDATED)) continue;
                removedStates.add(this.stateSerializer.createEntityURI(this.getValueFactory(), entityState.identity()));
            }
            if (!removedStates.isEmpty()) {
                Resource[] resources = removedStates.toArray(new Resource[removedStates.size()]);
                connection.remove(null, null, null, resources);
            }
        }

        private void indexEntityState(EntityState entityState, RepositoryConnection connection) throws RepositoryException {
            if (entityState.entityDescriptor().queryable()) {
                URI entityURI = this.stateSerializer.createEntityURI(this.getValueFactory(), entityState.identity());
                GraphImpl graph = new GraphImpl();
                this.stateSerializer.serialize(entityState, false, (Graph)graph);
                connection.add((Iterable)graph, new Resource[]{entityURI});
            }
        }

        private void indexEntityType(EntityDescriptor entityType, RepositoryConnection connection) throws RepositoryException {
            if (entityType.queryable()) {
                URI compositeURI = this.getValueFactory().createURI(Classes.toURI((Class)((Class)Iterables.first((Iterable)entityType.types()))));
                connection.clear(new Resource[]{compositeURI});
                Iterable statements = this.typeSerializer.serialize(entityType);
                connection.add(statements, new Resource[]{compositeURI});
            }
        }

        private ValueFactory getValueFactory() {
            if (this.valueFactory == null) {
                this.valueFactory = ((Repository)this.repository.get()).getValueFactory();
            }
            return this.valueFactory;
        }

        @Override
        public File dataDir() {
            return ((Repository)this.repository.get()).getDataDir();
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<RdfIndexingService>> {
        public void afterActivation(ServiceReference<RdfIndexingService> activated) throws Exception {
            ((RdfIndexingService)activated.get()).initialize();
        }
    }
}

