/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.query;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.qi4j.api.common.Optional;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.index.rdf.query.QualifiedIdentityResultCallback;
import org.qi4j.spi.query.EntityFinderException;

@Mixins(value={TupleQueryExecutorMixin.class})
public interface TupleQueryExecutor {
    public long performTupleQuery(QueryLanguage var1, String var2, @Optional Map<String, Object> var3, @Optional QualifiedIdentityResultCallback var4) throws EntityFinderException;

    public static class TupleQueryExecutorMixin
    implements TupleQueryExecutor {
        @Service
        private Repository repository;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long performTupleQuery(QueryLanguage language, String query, Map<String, Object> bindings, QualifiedIdentityResultCallback callback) throws EntityFinderException {
            long l;
            RepositoryConnection connection;
            block13: {
                connection = this.repository.getConnection();
                TupleQueryResult result = null;
                try {
                    TupleQuery tupleQuery = connection.prepareTupleQuery(language, query);
                    for (Map.Entry<String, Value> stringValueEntry : this.getBindings(bindings).entrySet()) {
                        tupleQuery.setBinding(stringValueEntry.getKey(), stringValueEntry.getValue());
                    }
                    tupleQuery.setIncludeInferred(false);
                    result = tupleQuery.evaluate();
                    long row = 0L;
                    while (result.hasNext() && !this.handleCallbacks(callback, result, row)) {
                        ++row;
                    }
                    l = row;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        throw throwable;
                    }
                    catch (RepositoryException e) {
                        throw new EntityFinderException((Throwable)e);
                    }
                    catch (MalformedQueryException e) {
                        throw new EntityFinderException((Throwable)e);
                    }
                    catch (QueryEvaluationException e) {
                        throw new EntityFinderException((Throwable)e);
                    }
                    catch (Exception e) {
                        throw new EntityFinderException((Throwable)e);
                    }
                }
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
            return l;
        }

        private boolean handleCallbacks(QualifiedIdentityResultCallback callback, TupleQueryResult result, long row) throws Exception {
            BindingSet bindingSet = (BindingSet)result.next();
            return callback != null && !this.processRow(row, bindingSet, callback);
        }

        private boolean processRow(long row, BindingSet bindingSet, QualifiedIdentityResultCallback callback) {
            Value identifier = bindingSet.getValue("identity");
            if (identifier == null) {
                return true;
            }
            String identity = identifier.stringValue();
            EntityReference entityReference = new EntityReference(identity);
            return callback.processRow(row, entityReference);
        }

        private Map<String, Value> getBindings(Map<String, Object> variables) {
            HashMap<String, Value> bindings = new HashMap<String, Value>();
            for (Map.Entry<String, Object> stringObjectEntry : variables.entrySet()) {
                if (stringObjectEntry.getValue().getClass().equals(Object.class)) continue;
                bindings.put(stringObjectEntry.getKey(), (Value)ValueFactoryImpl.getInstance().createLiteral(stringObjectEntry.getValue().toString()));
            }
            return bindings;
        }
    }
}

