/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.rdf.query.internal;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.query.grammar.AssociationFunction;
import org.qi4j.api.query.grammar.ManyAssociationFunction;
import org.qi4j.api.query.grammar.PropertyFunction;
import org.qi4j.api.util.Classes;
import org.qi4j.index.rdf.query.internal.Namespaces;

public class Triples
implements Iterable<Triple> {
    private int valueCounter = 0;
    private final List<Triple> triples = new ArrayList<Triple>();
    private final Namespaces namespaces;

    public Triples(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public void addDefaultTriples(String resultType) {
        this.triples.add(new Triple("?entityType", "rdfs:subClassOf", "<" + Classes.toURI((String)resultType) + ">", false));
        this.triples.add(new Triple("?entity", "rdf:type", "?entityType", false));
        this.triples.add(new Triple("?entity", this.addNamespace(QualifiedName.fromClass(Identity.class, (String)"identity").toNamespace()) + ":identity", "?identity", false));
    }

    private String addNamespace(String namespace) {
        return this.namespaces.addNamespace(namespace);
    }

    public Triple addTriple(PropertyFunction<?> propertyFunction, boolean optional) {
        String subject = "?entity";
        if (propertyFunction.traversedAssociation() != null) {
            subject = this.addTripleAssociation(propertyFunction.traversedAssociation(), false).value;
        } else if (propertyFunction.traversedProperty() != null) {
            subject = this.addTriple(propertyFunction.traversedProperty(), false).value;
        }
        QualifiedName qualifiedName = QualifiedName.fromAccessor((AccessibleObject)propertyFunction.accessor());
        String prefix = this.addNamespace(qualifiedName.toNamespace());
        return this.addTriple(subject, prefix + ":" + qualifiedName.name(), optional);
    }

    public Triple addTripleAssociation(AssociationFunction<?> associationReference, boolean optional) {
        String subject = "?entity";
        if (associationReference.traversedAssociation() != null) {
            subject = this.addTripleAssociation(associationReference.traversedAssociation(), false).value;
        }
        QualifiedName qualifiedName = QualifiedName.fromAccessor((AccessibleObject)associationReference.accessor());
        String prefix = this.addNamespace(qualifiedName.toNamespace());
        return this.addTriple(subject, prefix + ":" + qualifiedName.name(), optional);
    }

    public Triple addTripleManyAssociation(ManyAssociationFunction<?> manyAssociationReference, boolean optional) {
        AssociationFunction traversedAssociation = manyAssociationReference.traversedAssociation();
        String subject = "?entity";
        if (traversedAssociation != null) {
            subject = this.addTripleAssociation(traversedAssociation, false).value;
        }
        QualifiedName qualifiedName = QualifiedName.fromAccessor((AccessibleObject)manyAssociationReference.accessor());
        String predicatePrefix = this.addNamespace(qualifiedName.toNamespace());
        String predicate = predicatePrefix + ":" + qualifiedName.name();
        Triple collectionTriple = this.addTriple(subject, predicate, optional);
        String liSubject = collectionTriple.value;
        return this.addTriple(liSubject, "rdf:li", false);
    }

    private Triple addTriple(String subject, String predicate, boolean optional) {
        Triple triple = this.getTriple(subject, predicate);
        if (triple == null) {
            String value = "?v" + this.valueCounter++;
            triple = new Triple(subject, predicate, value, optional);
            this.triples.add(triple);
        }
        if (!optional && triple.optional) {
            triple.optional = false;
        }
        return triple;
    }

    private Triple getTriple(String subject, String predicate) {
        for (Triple triple : this.triples) {
            if (!triple.subject.equals(subject) || !triple.predicate.equals(predicate)) continue;
            return triple;
        }
        return null;
    }

    public boolean hasTriples() {
        return !this.triples.isEmpty();
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.triples.iterator();
    }

    public String toSparql() {
        StringBuilder sparql = new StringBuilder();
        for (Triple triple : this.triples) {
            sparql.append(triple.toSparql());
        }
        return sparql.toString();
    }

    public String toString() {
        return this.triples.toString();
    }

    public static class Triple {
        private final String subject;
        private final String predicate;
        private String value;
        private boolean optional;

        private Triple(String subject, String predicate, String value, boolean optional) {
            this.subject = subject;
            this.predicate = predicate;
            this.value = value;
            this.optional = optional;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null || this.getClass() != otherObject.getClass()) {
                return false;
            }
            Triple other = (Triple)otherObject;
            if (this.predicate != null ? !this.predicate.equals(other.predicate) : other.predicate != null) {
                return false;
            }
            if (this.subject != null ? !this.subject.equals(other.subject) : other.subject != null) {
                return false;
            }
            if (this.value != null) {
                return this.value.equals(other.value);
            }
            return other.value == null;
        }

        public int hashCode() {
            int result = this.subject != null ? this.subject.hashCode() : 0;
            result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.toSparql();
        }

        public String toSparql() {
            if (this.optional) {
                return String.format("OPTIONAL {%s %s %s}.", this.subject, this.predicate, this.value);
            }
            return String.format("%s %s %s.", this.subject, this.predicate, this.value);
        }

        public String subject() {
            return this.subject;
        }

        public String predicate() {
            return this.predicate;
        }

        public String value() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

