/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore;

import java.util.HashMap;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entitystore.EntityAlreadyExistsException;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreSPI;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.module.ModuleSpi;

public final class DefaultEntityStoreUnitOfWork
implements EntityStoreUnitOfWork {
    private EntityStoreSPI entityStoreSPI;
    private String identity;
    private HashMap<EntityReference, EntityState> states = new HashMap();
    private Usecase usecase;
    private long currentTime;

    public DefaultEntityStoreUnitOfWork(EntityStoreSPI entityStoreSPI, String identity, Usecase usecase, long currentTime) {
        this.entityStoreSPI = entityStoreSPI;
        this.identity = identity;
        this.usecase = usecase;
        this.currentTime = currentTime;
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public long currentTime() {
        return this.currentTime;
    }

    @Override
    public Usecase usecase() {
        return this.usecase;
    }

    @Override
    public EntityState newEntityState(ModuleSpi module, EntityReference anIdentity, EntityDescriptor descriptor) throws EntityStoreException {
        EntityState entityState = this.states.get(anIdentity);
        if (entityState != null) {
            throw new EntityAlreadyExistsException(anIdentity);
        }
        EntityState state = this.entityStoreSPI.newEntityState(this, module, anIdentity, descriptor);
        this.states.put(anIdentity, state);
        return state;
    }

    @Override
    public EntityState entityStateOf(ModuleSpi module, EntityReference anIdentity) throws EntityNotFoundException {
        EntityState entityState = this.states.get(anIdentity);
        if (entityState != null) {
            return entityState;
        }
        entityState = this.entityStoreSPI.entityStateOf(this, module, anIdentity);
        this.states.put(anIdentity, entityState);
        return entityState;
    }

    @Override
    public StateCommitter applyChanges() throws EntityStoreException {
        return this.entityStoreSPI.applyChanges(this, this.states.values());
    }

    @Override
    public void discard() {
    }
}

