/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.ConcurrentEntityStateModificationException;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.module.ModuleSpi;

@Mixins(value={EntityStateVersionsMixin.class})
public interface EntityStateVersions {
    public void forgetVersions(Iterable<EntityState> var1);

    public void rememberVersion(EntityReference var1, String var2);

    public void checkForConcurrentModification(Iterable<EntityState> var1, ModuleSpi var2, long var3) throws ConcurrentEntityStateModificationException;

    public static class EntityStateVersionsMixin
    implements EntityStateVersions {
        @This
        private EntityStore store;
        private final Map<EntityReference, String> versions = new WeakHashMap<EntityReference, String>();

        @Override
        public synchronized void forgetVersions(Iterable<EntityState> states) {
            for (EntityState state : states) {
                this.versions.remove(state.identity());
            }
        }

        @Override
        public synchronized void rememberVersion(EntityReference identity, String version) {
            this.versions.put(identity, version);
        }

        @Override
        public synchronized void checkForConcurrentModification(Iterable<EntityState> loaded, ModuleSpi module, long currentTime) throws ConcurrentEntityStateModificationException {
            ArrayList<EntityReference> changed = null;
            for (EntityState entityState : loaded) {
                if (entityState.status().equals((Object)EntityStatus.NEW)) continue;
                String storeVersion = this.versions.get(entityState.identity());
                if (storeVersion == null) {
                    EntityStoreUnitOfWork unitOfWork = this.store.newUnitOfWork(Usecase.DEFAULT, module, currentTime);
                    EntityState state = unitOfWork.entityStateOf(module, entityState.identity());
                    storeVersion = state.version();
                    unitOfWork.discard();
                }
                if (entityState.version().equals(storeVersion)) continue;
                if (changed == null) {
                    changed = new ArrayList<EntityReference>();
                }
                changed.add(entityState.identity());
            }
            if (changed != null) {
                throw new ConcurrentEntityStateModificationException(changed);
            }
        }
    }
}

