/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.util.Iterator;
import java.util.List;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entitystore.helpers.DefaultEntityState;

public final class DefaultManyAssociationState
implements ManyAssociationState {
    private DefaultEntityState entityState;
    private List<EntityReference> references;

    public DefaultManyAssociationState(DefaultEntityState entityState, List<EntityReference> references) {
        this.entityState = entityState;
        this.references = references;
    }

    @Override
    public int count() {
        return this.references.size();
    }

    @Override
    public boolean contains(EntityReference entityReference) {
        return this.references.contains(entityReference);
    }

    @Override
    public boolean add(int i, EntityReference entityReference) {
        if (this.references.contains(entityReference)) {
            return false;
        }
        this.references.add(i, entityReference);
        this.entityState.markUpdated();
        return true;
    }

    @Override
    public boolean remove(EntityReference entity) {
        boolean removed = this.references.remove(entity);
        this.entityState.markUpdated();
        return removed;
    }

    @Override
    public EntityReference get(int i) {
        return this.references.get(i);
    }

    @Override
    public Iterator<EntityReference> iterator() {
        final Iterator<EntityReference> iter = this.references.iterator();
        return new Iterator<EntityReference>(){
            EntityReference current;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public EntityReference next() {
                this.current = (EntityReference)iter.next();
                return this.current;
            }

            @Override
            public void remove() {
                iter.remove();
                DefaultManyAssociationState.this.entityState.markUpdated();
            }
        };
    }
}

