/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entity.NamedAssociationState;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.JSONManyAssociationState;
import org.qi4j.spi.entitystore.helpers.JSONNamedAssociationState;

public final class JSONEntityState
implements EntityState {
    private static final String[] EMPTY_NAMES = new String[0];
    private static final String[] CLONE_NAMES = new String[]{"identity", "application_version", "type", "version", "modified"};
    private final ValueSerialization valueSerialization;
    private final String version;
    private final EntityReference identity;
    private final EntityDescriptor entityDescriptor;
    private EntityStatus status;
    private long lastModified;
    private JSONObject state;

    JSONEntityState(long time, ValueSerialization valueSerialization, EntityReference identity, EntityDescriptor entityDescriptor, JSONObject initialState) {
        this(valueSerialization, "", time, identity, EntityStatus.NEW, entityDescriptor, initialState);
    }

    JSONEntityState(ValueSerialization valueSerialization, String version, long lastModified, EntityReference identity, EntityStatus status, EntityDescriptor entityDescriptor, JSONObject state) {
        this.valueSerialization = valueSerialization;
        this.version = version;
        this.lastModified = lastModified;
        this.identity = identity;
        this.status = status;
        this.entityDescriptor = entityDescriptor;
        this.state = state;
    }

    @Override
    public final String version() {
        return this.version;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public EntityReference identity() {
        return this.identity;
    }

    @Override
    public Object propertyValueOf(QualifiedName stateName) {
        try {
            Object json = this.state.getJSONObject("properties").opt(stateName.name());
            if (JSONObject.NULL.equals(json)) {
                return null;
            }
            PropertyDescriptor descriptor = this.entityDescriptor.state().findPropertyModelByQualifiedName(stateName);
            if (descriptor == null) {
                return null;
            }
            return this.valueSerialization.deserialize(descriptor.valueType(), json.toString());
        }
        catch (JSONException | ValueSerializationException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public void setPropertyValue(QualifiedName stateName, Object newValue) {
        try {
            String serialized;
            Object jsonValue = newValue == null || ValueType.isPrimitiveValue((Object)newValue) ? newValue : ((serialized = this.valueSerialization.serialize(newValue)).startsWith("{") ? new JSONObject(serialized) : (serialized.startsWith("[") ? new JSONArray(serialized) : serialized));
            this.cloneStateIfGlobalStateLoaded();
            this.state.getJSONObject("properties").put(stateName.name(), jsonValue);
            this.markUpdated();
        }
        catch (JSONException | ValueSerializationException e) {
            throw new EntityStoreException(e);
        }
    }

    private JSONObject cloneJSON(JSONObject jsonObject) throws JSONException {
        String[] names = JSONObject.getNames((JSONObject)jsonObject);
        if (names == null) {
            names = EMPTY_NAMES;
        }
        return new JSONObject(jsonObject, names);
    }

    @Override
    public EntityReference associationValueOf(QualifiedName stateName) {
        try {
            Object jsonValue = this.state.getJSONObject("associations").opt(stateName.name());
            if (jsonValue == null) {
                return null;
            }
            EntityReference value = jsonValue == JSONObject.NULL ? null : EntityReference.parseEntityReference((String)((String)jsonValue));
            return value;
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public void setAssociationValue(QualifiedName stateName, EntityReference newEntity) {
        try {
            this.cloneStateIfGlobalStateLoaded();
            this.state.getJSONObject("associations").put(stateName.name(), (Object)(newEntity == null ? null : newEntity.identity()));
            this.markUpdated();
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public ManyAssociationState manyAssociationValueOf(QualifiedName stateName) {
        try {
            JSONObject manyAssociations = this.state.getJSONObject("manyassociations");
            JSONArray jsonValues = manyAssociations.optJSONArray(stateName.name());
            if (jsonValues == null) {
                jsonValues = new JSONArray();
                manyAssociations.put(stateName.name(), (Object)jsonValues);
            }
            return new JSONManyAssociationState(this, jsonValues);
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public NamedAssociationState namedAssociationValueOf(QualifiedName stateName) {
        try {
            JSONObject namedAssociations = this.state.getJSONObject("namedassociations");
            JSONObject jsonValues = namedAssociations.optJSONObject(stateName.name());
            if (jsonValues == null) {
                jsonValues = new JSONObject();
                namedAssociations.put(stateName.name(), (Object)jsonValues);
            }
            return new JSONNamedAssociationState(this, jsonValues);
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public void remove() {
        this.status = EntityStatus.REMOVED;
    }

    @Override
    public EntityStatus status() {
        return this.status;
    }

    @Override
    public boolean isAssignableTo(Class<?> type) {
        return this.entityDescriptor.isAssignableTo(type);
    }

    @Override
    public EntityDescriptor entityDescriptor() {
        return this.entityDescriptor;
    }

    public JSONObject state() {
        return this.state;
    }

    public String toString() {
        return this.identity + "(" + this.state + ")";
    }

    public void markUpdated() {
        if (this.status == EntityStatus.LOADED) {
            this.status = EntityStatus.UPDATED;
        }
    }

    void cloneStateIfGlobalStateLoaded() {
        if (this.status != EntityStatus.LOADED) {
            return;
        }
        try {
            JSONObject newProperties = this.cloneJSON(this.state.getJSONObject("properties"));
            JSONObject newAssoc = this.cloneJSON(this.state.getJSONObject("associations"));
            JSONObject newManyAssoc = this.cloneJSON(this.state.getJSONObject("manyassociations"));
            JSONObject newNamedAssoc = this.cloneJSON(this.state.getJSONObject("namedassociations"));
            JSONObject stateClone = new JSONObject(this.state, CLONE_NAMES);
            stateClone.put("properties", (Object)newProperties);
            stateClone.put("associations", (Object)newAssoc);
            stateClone.put("manyassociations", (Object)newManyAssoc);
            stateClone.put("namedassociations", (Object)newNamedAssoc);
            this.state = stateClone;
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }
}

