/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.qi4j.api.cache.CacheOptions;
import org.qi4j.api.common.Optional;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.structure.Application;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.cache.Cache;
import org.qi4j.spi.cache.CachePool;
import org.qi4j.spi.cache.NullCache;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.DefaultEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreSPI;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.ModuleEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.entitystore.helpers.JSONEntityState;
import org.qi4j.spi.entitystore.helpers.JSONMapEntityStoreActivation;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;
import org.qi4j.spi.entitystore.helpers.Migration;
import org.qi4j.spi.entitystore.helpers.StateStore;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;

public class JSONMapEntityStoreMixin
implements EntityStore,
EntityStoreSPI,
StateStore,
JSONMapEntityStoreActivation {
    @This
    private MapEntityStore mapEntityStore;
    @This
    private EntityStoreSPI entityStoreSpi;
    @Structure
    private Qi4jSPI spi;
    @Structure
    private Application application;
    @Service
    @Tagged(value={"json"})
    private ValueSerialization valueSerialization;
    @Optional
    @Service
    private Migration migration;
    @Uses
    private ServiceDescriptor descriptor;
    @Optional
    @Service
    private CachePool caching;
    private Cache<CacheState> cache;
    protected String uuid;
    private int count;

    @Override
    public void setUpJSONMapES() throws Exception {
        this.uuid = this.descriptor.identity() + "-" + UUID.randomUUID().toString();
        this.cache = this.caching != null ? this.caching.fetchCache(this.uuid, CacheState.class) : new NullCache<CacheState>();
    }

    @Override
    public void tearDownJSONMapES() throws Exception {
        if (this.caching != null) {
            this.caching.returnCache(this.cache);
            this.cache = null;
        }
    }

    @Override
    public EntityStoreUnitOfWork newUnitOfWork(Usecase usecaseMetaInfo, ModuleSpi module, long currentTime) {
        EntityStoreUnitOfWork storeUnitOfWork = new DefaultEntityStoreUnitOfWork(this.entityStoreSpi, this.newUnitOfWorkId(), usecaseMetaInfo, currentTime);
        storeUnitOfWork = new ModuleEntityStoreUnitOfWork(module, storeUnitOfWork);
        return storeUnitOfWork;
    }

    @Override
    public EntityState newEntityState(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference identity, EntityDescriptor entityDescriptor) {
        try {
            JSONObject state = new JSONObject();
            state.put("identity", (Object)identity.identity());
            state.put("application_version", (Object)this.application.version());
            state.put("type", (Object)((Class)Iterables.first((Iterable)entityDescriptor.types())).getName());
            state.put("version", (Object)unitOfWork.identity());
            state.put("modified", unitOfWork.currentTime());
            state.put("properties", (Object)new JSONObject());
            state.put("associations", (Object)new JSONObject());
            state.put("manyassociations", (Object)new JSONObject());
            state.put("namedassociations", (Object)new JSONObject());
            return new JSONEntityState(unitOfWork.currentTime(), this.valueSerialization, identity, entityDescriptor, state);
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public synchronized EntityState entityStateOf(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference identity) {
        EntityState state = this.fetchCachedState(identity, module, unitOfWork.currentTime());
        if (state != null) {
            return state;
        }
        Reader in = this.mapEntityStore.get(identity);
        JSONEntityState loadedState = this.readEntityState(module, in);
        if (this.doCacheOnRead(unitOfWork)) {
            this.cache.put(identity.identity(), new CacheState(loadedState.state()));
        }
        return loadedState;
    }

    @Override
    public StateCommitter applyChanges(final EntityStoreUnitOfWork unitOfWork, final Iterable<EntityState> state) throws EntityStoreException {
        return new StateCommitter(){

            @Override
            public void commit() {
                try {
                    JSONMapEntityStoreMixin.this.mapEntityStore.applyChanges(new MapEntityStore.MapChanges(){

                        @Override
                        public void visitMap(MapEntityStore.MapChanger changer) throws IOException {
                            CacheOptions options = (CacheOptions)unitOfWork.usecase().metaInfo(CacheOptions.class);
                            if (options == null) {
                                options = CacheOptions.ALWAYS;
                            }
                            for (EntityState entityState : state) {
                                Throwable throwable;
                                Writer writer;
                                JSONEntityState state = (JSONEntityState)entityState;
                                if (state.status().equals((Object)EntityStatus.NEW)) {
                                    writer = changer.newEntity(state.identity(), state.entityDescriptor());
                                    throwable = null;
                                    try {
                                        JSONMapEntityStoreMixin.this.writeEntityState(state, writer, unitOfWork.identity(), unitOfWork.currentTime());
                                    }
                                    catch (Throwable x2) {
                                        throwable = x2;
                                        throw x2;
                                    }
                                    finally {
                                        if (writer != null) {
                                            if (throwable != null) {
                                                try {
                                                    writer.close();
                                                }
                                                catch (Throwable x2) {
                                                    throwable.addSuppressed(x2);
                                                }
                                            } else {
                                                writer.close();
                                            }
                                        }
                                    }
                                    if (!options.cacheOnNew()) continue;
                                    JSONMapEntityStoreMixin.this.cache.put(state.identity().identity(), new CacheState(state.state()));
                                    continue;
                                }
                                if (state.status().equals((Object)EntityStatus.UPDATED)) {
                                    writer = changer.updateEntity(state.identity(), state.entityDescriptor());
                                    throwable = null;
                                    try {
                                        JSONMapEntityStoreMixin.this.writeEntityState(state, writer, unitOfWork.identity(), unitOfWork.currentTime());
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        if (writer != null) {
                                            if (throwable != null) {
                                                try {
                                                    writer.close();
                                                }
                                                catch (Throwable x2) {
                                                    throwable.addSuppressed(x2);
                                                }
                                            } else {
                                                writer.close();
                                            }
                                        }
                                    }
                                    if (!options.cacheOnWrite()) continue;
                                    JSONMapEntityStoreMixin.this.cache.put(state.identity().identity(), new CacheState(state.state()));
                                    continue;
                                }
                                if (!state.status().equals((Object)EntityStatus.REMOVED)) continue;
                                changer.removeEntity(state.identity(), state.entityDescriptor());
                                JSONMapEntityStoreMixin.this.cache.remove(state.identity().identity());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new EntityStoreException(e);
                }
            }

            @Override
            public void cancel() {
            }
        };
    }

    @Override
    public Input<EntityState, EntityStoreException> entityStates(final ModuleSpi module) {
        return new Input<EntityState, EntityStoreException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super EntityState, ReceiverThrowableType> output) throws EntityStoreException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<EntityState, EntityStoreException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super EntityState, ReceiverThrowableType> receiver) throws ReceiverThrowableType, EntityStoreException {
                        final ArrayList migrated = new ArrayList();
                        try {
                            JSONMapEntityStoreMixin.this.mapEntityStore.entityStates().transferTo(new Output<Reader, ReceiverThrowableType>(){

                                public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends Reader, SenderThrowableType> sender) throws Throwable, Throwable {
                                    sender.sendTo(new Receiver<Reader, ReceiverThrowableType>(){

                                        public void receive(Reader item) throws Throwable {
                                            JSONEntityState entity = JSONMapEntityStoreMixin.this.readEntityState(module, item);
                                            if (entity.status() == EntityStatus.UPDATED) {
                                                migrated.add(entity);
                                                if (migrated.size() > 100) {
                                                    try {
                                                        JSONMapEntityStoreMixin.this.synchMigratedEntities(migrated);
                                                    }
                                                    catch (IOException e) {
                                                        throw new EntityStoreException("Synchronization of Migrated Entities failed.", e);
                                                    }
                                                }
                                            }
                                            receiver.receive((Object)entity);
                                        }
                                    });
                                    if (!migrated.isEmpty()) {
                                        try {
                                            JSONMapEntityStoreMixin.this.synchMigratedEntities(migrated);
                                        }
                                        catch (IOException e) {
                                            throw new EntityStoreException("Synchronization of Migrated Entities failed.", e);
                                        }
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new EntityStoreException(e);
                        }
                    }
                });
            }
        };
    }

    private void synchMigratedEntities(final List<EntityState> migratedEntities) throws IOException {
        this.mapEntityStore.applyChanges(new MapEntityStore.MapChanges(){

            @Override
            public void visitMap(MapEntityStore.MapChanger changer) throws IOException {
                for (EntityState migratedEntity : migratedEntities) {
                    JSONEntityState state = (JSONEntityState)migratedEntity;
                    Writer writer = changer.updateEntity(state.identity(), state.entityDescriptor());
                    Throwable throwable = null;
                    try {
                        JSONMapEntityStoreMixin.this.writeEntityState(state, writer, state.version(), state.lastModified());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
            }
        });
        migratedEntities.clear();
    }

    protected String newUnitOfWorkId() {
        return this.uuid + Integer.toHexString(this.count++);
    }

    protected void writeEntityState(JSONEntityState state, Writer writer, String identity, long lastModified) throws EntityStoreException {
        try {
            JSONObject jsonState = state.state();
            jsonState.put("version", (Object)identity);
            jsonState.put("modified", lastModified);
            writer.append(jsonState.toString());
        }
        catch (IOException | JSONException e) {
            throw new EntityStoreException("Could not store EntityState", e);
        }
    }

    protected JSONEntityState readEntityState(ModuleSpi module, Reader entityState) throws EntityStoreException {
        try {
            String type;
            EntityDescriptor entityDescriptor;
            String currentAppVersion;
            JSONObject jsonObject = new JSONObject(new JSONTokener(entityState));
            EntityStatus status = EntityStatus.LOADED;
            String version = jsonObject.getString("version");
            long modified = jsonObject.getLong("modified");
            String identity = jsonObject.getString("identity");
            if (!jsonObject.has("namedassociations")) {
                jsonObject.put("namedassociations", (Object)new JSONObject());
            }
            if (!(currentAppVersion = jsonObject.optString("application_version", "0.0")).equals(this.application.version())) {
                if (this.migration != null) {
                    this.migration.migrate(jsonObject, this.application.version(), this);
                } else {
                    jsonObject.put("application_version", (Object)this.application.version());
                }
                status = EntityStatus.UPDATED;
            }
            if ((entityDescriptor = module.entityDescriptor(type = jsonObject.getString("type"))) == null) {
                throw new EntityTypeNotFoundException(type, module.name(), Iterables.map(ModelModule.toStringFunction, module.findVisibleEntityTypes()));
            }
            return new JSONEntityState(this.valueSerialization, version, modified, EntityReference.parseEntityReference((String)identity), status, entityDescriptor, jsonObject);
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject jsonStateOf(String id) throws IOException {
        try (Reader reader = this.mapEntityStore.get(EntityReference.parseEntityReference((String)id));){
            JSONObject jSONObject = new JSONObject(new JSONTokener(reader));
            return jSONObject;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    private EntityState fetchCachedState(EntityReference identity, ModuleSpi module, long currentTime) {
        CacheState cacheState = this.cache.get(identity.identity());
        if (cacheState != null) {
            JSONObject data = cacheState.json;
            try {
                String type = data.getString("type");
                EntityDescriptor entityDescriptor = module.entityDescriptor(type);
                return new JSONEntityState(this.valueSerialization, data.getString("version"), data.getLong("modified"), identity, EntityStatus.LOADED, entityDescriptor, data);
            }
            catch (JSONException e) {
                throw new EntityStoreException(e);
            }
        }
        return null;
    }

    private boolean doCacheOnRead(EntityStoreUnitOfWork unitOfWork) {
        CacheOptions cacheOptions = (CacheOptions)unitOfWork.usecase().metaInfo(CacheOptions.class);
        return cacheOptions == null || cacheOptions.cacheOnRead();
    }

    public static class CacheState
    implements Externalizable {
        public JSONObject json;

        public CacheState() {
        }

        private CacheState(JSONObject state) {
            this.json = state;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.json.toString());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            try {
                this.json = new JSONObject(in.readUTF());
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
    }
}

