/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.spi.entity.NamedAssociationState;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.JSONEntityState;

public final class JSONNamedAssociationState
implements NamedAssociationState {
    private final JSONEntityState entityState;
    private final JSONObject references;

    public JSONNamedAssociationState(JSONEntityState entityState, JSONObject references) {
        this.entityState = entityState;
        this.references = references;
    }

    @Override
    public int count() {
        return this.references.length();
    }

    @Override
    public boolean containsName(String name) {
        return this.references.has(name);
    }

    @Override
    public boolean put(String name, EntityReference entityReference) {
        try {
            if (this.references.has(name) && entityReference.identity().equals(this.references.getString(name))) {
                return false;
            }
            this.entityState.cloneStateIfGlobalStateLoaded();
            this.references.put(name, (Object)entityReference.identity());
            this.entityState.markUpdated();
            return true;
        }
        catch (JSONException ex) {
            throw new EntityStoreException(ex);
        }
    }

    @Override
    public boolean remove(String name) {
        if (!this.references.has(name)) {
            return false;
        }
        this.entityState.cloneStateIfGlobalStateLoaded();
        this.references.remove(name);
        this.entityState.markUpdated();
        return true;
    }

    @Override
    public EntityReference get(String name) {
        try {
            return new EntityReference(this.references.getString(name));
        }
        catch (JSONException ex) {
            return null;
        }
    }

    @Override
    public String nameOf(EntityReference entityReference) {
        JSONArray names = this.references.names();
        if (names == null) {
            return null;
        }
        try {
            for (int idx = 0; idx < names.length(); ++idx) {
                String name = names.getString(idx);
                if (!entityReference.identity().equals(this.references.getString(name))) continue;
                return name;
            }
            return null;
        }
        catch (JSONException ex) {
            throw new EntityStoreException(ex);
        }
    }

    @Override
    public Iterator<String> iterator() {
        final JSONArray names = this.references.names() == null ? new JSONArray() : this.references.names();
        return new Iterator<String>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < names.length();
            }

            @Override
            public String next() {
                try {
                    String next = names.getString(this.idx);
                    ++this.idx;
                    return next;
                }
                catch (JSONException ex) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() is not supported on NamedAssociation iterators.");
            }
        };
    }

    public String toString() {
        return this.references.toString();
    }
}

