/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.metrics;

import org.qi4j.api.metrics.MetricsCounterFactory;
import org.qi4j.api.metrics.MetricsFactory;
import org.qi4j.api.metrics.MetricsGaugeFactory;
import org.qi4j.api.metrics.MetricsHealthCheckFactory;
import org.qi4j.api.metrics.MetricsHistogramFactory;
import org.qi4j.api.metrics.MetricsMeterFactory;
import org.qi4j.api.metrics.MetricsNotSupportedException;
import org.qi4j.api.metrics.MetricsProvider;
import org.qi4j.api.metrics.MetricsTimerFactory;
import org.qi4j.spi.metrics.NullMetricsFactory;

public class MetricsProviderAdapter
implements MetricsProvider {
    private static final MetricsCounterFactory NULL_COUNTER_FACTORY = new NullMetricsFactory.NullCounterFactory();
    private static final MetricsGaugeFactory NULL_GAUGE_FACTORY = new NullMetricsFactory.NullGaugeFactory();
    private static final MetricsMeterFactory NULL_METER_FACTORY = new NullMetricsFactory.NullMeterFactory();
    private static final MetricsHistogramFactory NULL_HISTOGRAM_FACTORY = new NullMetricsFactory.NullHistogramFactory();
    private static final MetricsTimerFactory NULL_TIMER_FACTORY = new NullMetricsFactory.NullTimerFactory();
    private static final MetricsHealthCheckFactory NULL_HEALTHCHECK_FACTORY = new NullMetricsFactory.NullHealthCheckFactory();

    public <T extends MetricsFactory> T createFactory(Class<T> factoryType) {
        if (factoryType.equals(MetricsCounterFactory.class)) {
            return (T)this.createMetricsCounterFactory();
        }
        if (factoryType.equals(MetricsGaugeFactory.class)) {
            return (T)this.createMetricsGaugeFactory();
        }
        if (factoryType.equals(MetricsHealthCheckFactory.class)) {
            return (T)this.createMetricsHealthCheckFactory();
        }
        if (factoryType.equals(MetricsHistogramFactory.class)) {
            return (T)this.createMetricsHistogramFactory();
        }
        if (factoryType.equals(MetricsMeterFactory.class)) {
            return (T)this.createMetricsMeterFactory();
        }
        if (factoryType.equals(MetricsTimerFactory.class)) {
            return (T)this.createMetricsTimerFactory();
        }
        throw new MetricsNotSupportedException(factoryType, this.getClass());
    }

    protected MetricsTimerFactory createMetricsTimerFactory() {
        return NULL_TIMER_FACTORY;
    }

    protected MetricsMeterFactory createMetricsMeterFactory() {
        return NULL_METER_FACTORY;
    }

    protected MetricsHistogramFactory createMetricsHistogramFactory() {
        return NULL_HISTOGRAM_FACTORY;
    }

    protected MetricsHealthCheckFactory createMetricsHealthCheckFactory() {
        return NULL_HEALTHCHECK_FACTORY;
    }

    protected MetricsGaugeFactory createMetricsGaugeFactory() {
        return NULL_GAUGE_FACTORY;
    }

    protected MetricsCounterFactory createMetricsCounterFactory() {
        return NULL_COUNTER_FACTORY;
    }
}

