/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.module;

import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.spi.module.ModuleSpi;

public class ModelModule<T extends ModelDescriptor> {
    public static Function<?, String> toStringFunction = new Function<ModelModule<?>, String>(){

        public String map(ModelModule item) {
            return ((Class)item.model().types().iterator().next()).getName() + "[" + item.module().name() + "]";
        }
    };
    private final ModuleSpi module;
    private final T model;

    public static <T extends ModelDescriptor> Function<T, ModelModule<T>> modelModuleFunction(final ModuleSpi module) {
        return new Function<T, ModelModule<T>>(){

            public ModelModule<T> map(T model) {
                return new ModelModule(module, model);
            }
        };
    }

    public static <T extends ModelDescriptor> Function<ModelModule<T>, T> modelFunction() {
        return new Function<ModelModule<T>, T>(){

            public T map(ModelModule<T> modelModule) {
                return modelModule.model();
            }
        };
    }

    public ModelModule(ModuleSpi module, T model) {
        this.module = module;
        this.model = model;
    }

    public ModuleSpi module() {
        return this.module;
    }

    public T model() {
        return this.model;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelModule that = (ModelModule)o;
        if (this.model != null ? !this.model.equals(that.model) : that.model != null) {
            return false;
        }
        return !(this.module == null ? that.module != null : !this.module.equals(that.module));
    }

    public int hashCode() {
        int result = this.module != null ? this.module.hashCode() : 0;
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.module.name() + ":" + this.model;
    }
}

