/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.EnumType;
import org.qi4j.api.type.MapType;
import org.qi4j.api.type.Serialization;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.util.Base64Encoder;
import org.qi4j.api.util.Dates;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.api.value.ValueDeserializer;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;

public abstract class ValueDeserializerAdapter<InputType, InputNodeType>
implements ValueDeserializer {
    private static final String UTF_8 = "UTF-8";
    private final Map<Class<?>, Function<Object, Object>> deserializers = new HashMap(16);
    private final Map<Class<?>, ComplexDeserializer<Object, InputType, InputNodeType>> complexDeserializers = new HashMap(2);
    private final Application application;
    private final Module module;
    private Function<Application, Module> valuesModuleFinder;
    private Module valuesModule;

    protected final <T> void registerDeserializer(Class<T> type, Function<Object, T> deserializer) {
        this.deserializers.put(type, deserializer);
    }

    protected final <T> void registerComplexDeserializer(Class<T> type, ComplexDeserializer<T, InputType, InputNodeType> deserializer) {
        this.complexDeserializers.put(type, deserializer);
    }

    public ValueDeserializerAdapter(@Structure Application application, @Structure Module module, @Service ServiceReference<ValueDeserializer> serviceRef) {
        this(application, module, (Function<Application, Module>)((Function)serviceRef.metaInfo(Function.class)));
    }

    protected ValueDeserializerAdapter(Application application, Module module, Function<Application, Module> valuesModuleFinder) {
        this.application = application;
        this.module = module;
        this.setValuesModuleFinder(valuesModuleFinder);
        this.registerDeserializer(String.class, new Function<Object, String>(){

            public String map(Object input) {
                return input.toString();
            }
        });
        this.registerDeserializer(Character.class, new Function<Object, Character>(){

            public Character map(Object input) {
                return Character.valueOf(input.toString().charAt(0));
            }
        });
        this.registerDeserializer(Boolean.class, new Function<Object, Boolean>(){

            public Boolean map(Object input) {
                return input instanceof String ? Boolean.parseBoolean((String)input) : (Boolean)input;
            }
        });
        this.registerDeserializer(Integer.class, new Function<Object, Integer>(){

            public Integer map(Object input) {
                return input instanceof String ? Integer.parseInt((String)input) : ((Number)input).intValue();
            }
        });
        this.registerDeserializer(Long.class, new Function<Object, Long>(){

            public Long map(Object input) {
                return input instanceof String ? Long.parseLong((String)input) : ((Number)input).longValue();
            }
        });
        this.registerDeserializer(Short.class, new Function<Object, Short>(){

            public Short map(Object input) {
                return input instanceof String ? Short.parseShort((String)input) : ((Number)input).shortValue();
            }
        });
        this.registerDeserializer(Byte.class, new Function<Object, Byte>(){

            public Byte map(Object input) {
                return input instanceof String ? Byte.parseByte((String)input) : ((Number)input).byteValue();
            }
        });
        this.registerDeserializer(Float.class, new Function<Object, Float>(){

            public Float map(Object input) {
                return Float.valueOf(input instanceof String ? Float.parseFloat((String)input) : ((Number)input).floatValue());
            }
        });
        this.registerDeserializer(Double.class, new Function<Object, Double>(){

            public Double map(Object input) {
                return input instanceof String ? Double.parseDouble((String)input) : ((Number)input).doubleValue();
            }
        });
        this.registerDeserializer(BigDecimal.class, new Function<Object, BigDecimal>(){

            public BigDecimal map(Object input) {
                return new BigDecimal(input.toString());
            }
        });
        this.registerDeserializer(BigInteger.class, new Function<Object, BigInteger>(){

            public BigInteger map(Object input) {
                return new BigInteger(input.toString());
            }
        });
        this.registerDeserializer(Date.class, new Function<Object, Date>(){

            public Date map(Object input) {
                return Dates.fromString((String)input.toString());
            }
        });
        this.registerDeserializer(DateTime.class, new Function<Object, DateTime>(){

            public DateTime map(Object input) {
                return DateTime.parse((String)input.toString());
            }
        });
        this.registerDeserializer(LocalDateTime.class, new Function<Object, LocalDateTime>(){

            public LocalDateTime map(Object input) {
                return new LocalDateTime(input);
            }
        });
        this.registerDeserializer(LocalDate.class, new Function<Object, LocalDate>(){

            public LocalDate map(Object input) {
                return new LocalDate(input);
            }
        });
        this.registerDeserializer(EntityReference.class, new Function<Object, EntityReference>(){

            public EntityReference map(Object input) {
                return EntityReference.parseEntityReference((String)input.toString());
            }
        });
    }

    private void setValuesModuleFinder(Function<Application, Module> valuesModuleFinder) {
        this.valuesModuleFinder = valuesModuleFinder;
        this.valuesModule = null;
    }

    private Module valuesModule() {
        if (this.valuesModule == null) {
            if (this.valuesModuleFinder == null) {
                this.valuesModule = this.module;
            } else {
                this.valuesModule = (Module)this.valuesModuleFinder.map((Object)this.application);
                if (this.valuesModule == null) {
                    throw new ValueSerializationException("Values Module provided by the finder Function was null.");
                }
            }
        }
        return this.valuesModule;
    }

    public <T> Function<String, T> deserialize(Class<T> type) {
        if (CollectionType.isCollection(type)) {
            ValueType objectValueType = new ValueType(Object.class);
            return this.deserialize((ValueType)new CollectionType(type, objectValueType));
        }
        if (MapType.isMap(type)) {
            ValueType objectValueType = new ValueType(Object.class);
            return this.deserialize((ValueType)new MapType(type, objectValueType, objectValueType));
        }
        return this.deserialize(new ValueType(type));
    }

    public final <T> Function<String, T> deserialize(final ValueType valueType) {
        return new Function<String, T>(){

            public T map(String input) {
                return ValueDeserializerAdapter.this.deserialize(valueType, input);
            }
        };
    }

    public final <T> Function2<ValueType, String, T> deserialize() {
        return new Function2<ValueType, String, T>(){

            public T map(ValueType valueType, String input) {
                return ValueDeserializerAdapter.this.deserialize(valueType, input);
            }
        };
    }

    public final <T> T deserialize(Class<?> type, String input) throws ValueSerializationException {
        if (CollectionType.isCollection(type)) {
            ValueType objectValueType = new ValueType(Object.class);
            return this.deserialize((ValueType)new CollectionType(type, objectValueType), input);
        }
        if (MapType.isMap(type)) {
            ValueType objectValueType = new ValueType(Object.class);
            return this.deserialize((ValueType)new MapType(type, objectValueType, objectValueType), input);
        }
        return this.deserialize(new ValueType(type), input);
    }

    public final <T> T deserialize(ValueType valueType, String input) throws ValueSerializationException {
        try {
            return this.deserializeRoot(valueType, new ByteArrayInputStream(input.getBytes(UTF_8)));
        }
        catch (ValueSerializationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValueSerializationException("Could not deserialize value", (Throwable)ex);
        }
    }

    public final <T> T deserialize(Class<?> type, InputStream input) throws ValueSerializationException {
        if (CollectionType.isCollection(type)) {
            ValueType objectValueType = new ValueType(Object.class);
            return this.deserialize((ValueType)new CollectionType(type, objectValueType), input);
        }
        if (MapType.isMap(type)) {
            ValueType objectValueType = new ValueType(Object.class);
            return this.deserialize((ValueType)new MapType(type, objectValueType, objectValueType), input);
        }
        return this.deserialize(new ValueType(type), input);
    }

    public final <T> T deserialize(ValueType valueType, InputStream input) throws ValueSerializationException {
        try {
            return this.deserializeRoot(valueType, input);
        }
        catch (ValueSerializationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValueSerializationException("Could not deserialize value", (Throwable)ex);
        }
    }

    private <T> T deserializeRoot(ValueType valueType, InputStream input) throws Exception {
        Class type = (Class)Iterables.first((Iterable)valueType.types());
        if (this.deserializers.get(type) != null) {
            Scanner scanner = new Scanner(input, UTF_8).useDelimiter("\\A");
            if (!scanner.hasNext()) {
                return (T)(String.class.equals((Object)type) ? "" : null);
            }
            String string = scanner.next();
            return (T)this.deserializers.get(type).map((Object)string);
        }
        if (type.isArray()) {
            Scanner scanner = new Scanner(input, UTF_8).useDelimiter("\\A");
            if (!scanner.hasNext()) {
                return null;
            }
            String string = scanner.next();
            return this.deserializeBase64Serialized(string);
        }
        InputType adaptedInput = this.adaptInput(input);
        this.onDeserializationStart(valueType, adaptedInput);
        T deserialized = this.doDeserialize(valueType, adaptedInput);
        this.onDeserializationEnd(valueType, adaptedInput);
        return deserialized;
    }

    private <T> T doDeserialize(ValueType valueType, InputType input) throws Exception {
        Class type = (Class)Iterables.first((Iterable)valueType.types());
        if (this.deserializers.get(type) != null) {
            Object value = this.readPlainValue(input);
            if (value == null) {
                return null;
            }
            return (T)this.deserializers.get(type).map(value);
        }
        if (this.complexDeserializers.get(type) != null) {
            return (T)this.complexDeserializers.get(type).deserializePull(input);
        }
        if (ValueCompositeType.class.isAssignableFrom(valueType.getClass())) {
            return this.deserializeValueComposite(valueType, input);
        }
        if (CollectionType.class.isAssignableFrom(valueType.getClass())) {
            return (T)this.deserializeCollection((CollectionType)valueType, input);
        }
        if (MapType.class.isAssignableFrom(valueType.getClass())) {
            return (T)this.deserializeMap((MapType)valueType, input);
        }
        if (EnumType.class.isAssignableFrom(valueType.getClass()) || type.isEnum()) {
            return Enum.valueOf(type, this.readPlainValue(input).toString());
        }
        if (type.isArray()) {
            return this.deserializeBase64Serialized(this.readPlainValue(input).toString());
        }
        return this.deserializeGuessed(valueType, input);
    }

    private <T> Function<InputType, T> buildDeserializeInputFunction(final ValueType valueType) {
        return new Function<InputType, T>(){

            public T map(InputType input) {
                try {
                    return ValueDeserializerAdapter.this.doDeserialize(valueType, input);
                }
                catch (ValueSerializationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ValueSerializationException((Throwable)ex);
                }
            }
        };
    }

    private <T> Collection<T> deserializeCollection(CollectionType collectionType, InputType input) throws Exception {
        Class collectionMainType = (Class)Iterables.first((Iterable)collectionType.types());
        AbstractCollection collection = Set.class.equals((Object)collectionMainType) ? new LinkedHashSet() : new ArrayList();
        return this.readArrayInCollection(input, this.buildDeserializeInputFunction(collectionType.collectedType()), collection);
    }

    private <K, V> Map<K, V> deserializeMap(MapType mapType, InputType input) throws Exception {
        return this.readMapInMap(input, this.buildDeserializeInputFunction(mapType.keyType()), this.buildDeserializeInputFunction(mapType.valueType()), new HashMap());
    }

    private <T> T deserializeValueComposite(ValueType valueType, InputType input) throws Exception {
        InputNodeType inputNode = this.readObjectTree(input);
        if (inputNode == null) {
            return null;
        }
        return this.deserializeNodeValueComposite(valueType, inputNode);
    }

    private <T> T deserializeNodeValueComposite(ValueType valueType, InputNodeType inputNode) throws Exception {
        ValueCompositeType valueCompositeType = (ValueCompositeType)valueType;
        Class<?> valueBuilderType = (Class<?>)Iterables.first((Iterable)valueCompositeType.types());
        String typeInfo = (String)this.getObjectFieldValue(inputNode, "_type", this.buildDeserializeInputNodeFunction(new ValueType(String.class)));
        if (typeInfo != null) {
            ValueDescriptor valueDescriptor = this.valuesModule().valueDescriptor(typeInfo);
            if (valueDescriptor == null) {
                throw new ValueSerializationException("Specified value type could not be resolved: " + typeInfo);
            }
            valueCompositeType = valueDescriptor.valueType();
            valueBuilderType = Class.forName(typeInfo);
        }
        return this.deserializeValueComposite(valueCompositeType, valueBuilderType, inputNode);
    }

    private <T> T deserializeValueComposite(ValueCompositeType valueCompositeType, Class<?> valueBuilderType, InputNodeType inputNode) throws Exception {
        Object value;
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        for (PropertyDescriptor property : valueCompositeType.properties()) {
            String propertyName = property.qualifiedName().name();
            if (this.objectHasField(inputNode, propertyName)) {
                value = this.getObjectFieldValue(inputNode, propertyName, this.buildDeserializeInputNodeFunction(property.valueType()));
                if (property.isImmutable()) {
                    if (value instanceof Set) {
                        value = Collections.unmodifiableSet((Set)value);
                    } else if (value instanceof List) {
                        value = Collections.unmodifiableList((List)value);
                    } else if (value instanceof Map) {
                        value = Collections.unmodifiableMap((Map)value);
                    }
                }
            } else {
                value = property.initialValue(this.valuesModule());
            }
            stateMap.put(propertyName, value);
        }
        for (AssociationDescriptor association : valueCompositeType.associations()) {
            String associationName = association.qualifiedName().name();
            if (!this.objectHasField(inputNode, associationName)) continue;
            value = this.getObjectFieldValue(inputNode, associationName, this.buildDeserializeInputNodeFunction(new ValueType(EntityReference.class)));
            stateMap.put(associationName, value);
        }
        for (AssociationDescriptor manyAssociation : valueCompositeType.manyAssociations()) {
            String manyAssociationName = manyAssociation.qualifiedName().name();
            if (!this.objectHasField(inputNode, manyAssociationName)) continue;
            value = this.getObjectFieldValue(inputNode, manyAssociationName, this.buildDeserializeInputNodeFunction((ValueType)new CollectionType(Collection.class, new ValueType(EntityReference.class))));
            stateMap.put(manyAssociationName, value);
        }
        for (AssociationDescriptor namedAssociation : valueCompositeType.namedAssociations()) {
            String namedAssociationName = namedAssociation.qualifiedName().name();
            if (!this.objectHasField(inputNode, namedAssociationName)) continue;
            value = this.getObjectFieldValue(inputNode, namedAssociationName, this.buildDeserializeInputNodeFunction((ValueType)MapType.of(String.class, EntityReference.class, (Serialization.Variant)Serialization.Variant.object)));
            stateMap.put(namedAssociationName, value);
        }
        ValueBuilder<?> valueBuilder = this.buildNewValueBuilderWithState(valueBuilderType, stateMap);
        return (T)valueBuilder.newInstance();
    }

    private <T> Function<InputNodeType, T> buildDeserializeInputNodeFunction(final ValueType valueType) {
        return new Function<InputNodeType, T>(){

            public T map(InputNodeType inputNode) {
                try {
                    return ValueDeserializerAdapter.this.doDeserializeInputNodeValue(valueType, inputNode);
                }
                catch (ValueSerializationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ValueSerializationException((Throwable)ex);
                }
            }
        };
    }

    private <T> T doDeserializeInputNodeValue(ValueType valueType, InputNodeType inputNode) throws Exception {
        if (inputNode == null) {
            return null;
        }
        Class type = (Class)Iterables.first((Iterable)valueType.types());
        if (this.deserializers.get(type) != null) {
            Object value = this.asSimpleValue(inputNode);
            if (value == null) {
                return null;
            }
            return (T)this.deserializers.get(type).map(value);
        }
        if (this.complexDeserializers.get(type) != null) {
            return (T)this.complexDeserializers.get(type).deserializeTree(inputNode);
        }
        if (ValueCompositeType.class.isAssignableFrom(valueType.getClass())) {
            return this.deserializeNodeValueComposite(valueType, inputNode);
        }
        if (CollectionType.class.isAssignableFrom(valueType.getClass())) {
            return (T)this.deserializeNodeCollection((CollectionType)valueType, inputNode);
        }
        if (MapType.class.isAssignableFrom(valueType.getClass())) {
            MapType mapType = (MapType)valueType;
            if (mapType.variant().equals((Object)Serialization.Variant.entry)) {
                return (T)this.deserializeNodeEntryMap((MapType)valueType, inputNode);
            }
            return (T)this.deserializeNodeObjectMap((MapType)valueType, inputNode);
        }
        if (EnumType.class.isAssignableFrom(valueType.getClass()) || type.isEnum()) {
            Object value = this.asSimpleValue(inputNode);
            if (value == null) {
                return null;
            }
            return Enum.valueOf(type, value.toString());
        }
        return this.deserializeNodeGuessed(valueType, inputNode);
    }

    private ValueBuilder<?> buildNewValueBuilderWithState(Class<?> type, final Map<String, Object> stateMap) {
        return this.valuesModule().newValueBuilderWithState(type, (Function)new Function<PropertyDescriptor, Object>(){

            public Object map(PropertyDescriptor property) {
                return stateMap.get(property.qualifiedName().name());
            }
        }, (Function)new Function<AssociationDescriptor, EntityReference>(){

            public EntityReference map(AssociationDescriptor association) {
                Object entityRef = stateMap.get(association.qualifiedName().name());
                if (entityRef == null) {
                    return null;
                }
                return (EntityReference)entityRef;
            }
        }, (Function)new Function<AssociationDescriptor, Iterable<EntityReference>>(){

            public Iterable<EntityReference> map(AssociationDescriptor manyAssociation) {
                Object entityRefs = stateMap.get(manyAssociation.qualifiedName().name());
                if (entityRefs == null) {
                    return Iterables.empty();
                }
                return (Iterable)entityRefs;
            }
        }, (Function)new Function<AssociationDescriptor, Map<String, EntityReference>>(){

            public Map<String, EntityReference> map(AssociationDescriptor namedAssociation) {
                Object entityRefs = stateMap.get(namedAssociation.qualifiedName().name());
                if (entityRefs == null) {
                    return Collections.emptyMap();
                }
                return (Map)entityRefs;
            }
        });
    }

    private <T> T deserializeGuessed(ValueType valueType, InputType input) throws Exception {
        InputNodeType inputNode = this.readObjectTree(input);
        if (inputNode == null) {
            return null;
        }
        return this.deserializeNodeGuessed(valueType, inputNode);
    }

    private <T> Collection<T> deserializeNodeCollection(CollectionType collectionType, InputNodeType inputNode) throws Exception {
        Class collectionMainType = (Class)Iterables.first((Iterable)collectionType.types());
        AbstractCollection collection = Set.class.equals((Object)collectionMainType) ? new LinkedHashSet() : new ArrayList();
        this.putArrayNodeInCollection(inputNode, this.buildDeserializeInputNodeFunction(collectionType.collectedType()), collection);
        return collection;
    }

    private <K, V> Map<K, V> deserializeNodeEntryMap(MapType mapType, InputNodeType inputNode) throws Exception {
        HashMap map = new HashMap();
        this.putArrayNodeInMap(inputNode, this.buildDeserializeInputNodeFunction(mapType.keyType()), this.buildDeserializeInputNodeFunction(mapType.valueType()), map);
        return map;
    }

    private <V> Map<String, V> deserializeNodeObjectMap(MapType mapType, InputNodeType inputNode) throws Exception {
        HashMap map = new HashMap();
        this.putObjectNodeInMap(inputNode, this.buildDeserializeInputNodeFunction(mapType.valueType()), map);
        return map;
    }

    private <T> T deserializeNodeGuessed(ValueType valueType, InputNodeType inputNode) throws Exception {
        if (this.isObjectValue(inputNode)) {
            ValueCompositeType valueCompositeType;
            if (this.objectHasField(inputNode, "_type")) {
                String typeInfo = (String)this.getObjectFieldValue(inputNode, "_type", this.buildDeserializeInputNodeFunction(new ValueType(String.class)));
                ValueDescriptor valueDescriptor = this.valuesModule().valueDescriptor(typeInfo);
                if (valueDescriptor == null) {
                    throw new ValueSerializationException("Specified value type could not be resolved: " + typeInfo);
                }
                valueCompositeType = valueDescriptor.valueType();
            } else {
                ValueDescriptor valueDescriptor = this.valuesModule().valueDescriptor(((Class)Iterables.first((Iterable)valueType.types())).getName());
                if (valueDescriptor == null) {
                    throw new ValueSerializationException("Don't know how to deserialize " + inputNode);
                }
                valueCompositeType = valueDescriptor.valueType();
            }
            Class valueBuilderType = (Class)Iterables.first((Iterable)valueCompositeType.types());
            return this.deserializeValueComposite(valueCompositeType, valueBuilderType, inputNode);
        }
        return this.deserializeBase64Serialized(inputNode);
    }

    private <T> T deserializeBase64Serialized(InputNodeType inputNode) throws Exception {
        Object value = this.asSimpleValue(inputNode);
        if (value == null) {
            return null;
        }
        String base64 = value.toString();
        return this.deserializeBase64Serialized(base64);
    }

    private <T> T deserializeBase64Serialized(String inputString) throws Exception {
        Object result;
        byte[] bytes = inputString.getBytes(UTF_8);
        bytes = Base64Encoder.decode((byte[])bytes);
        try (ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            result = oin.readObject();
        }
        return (T)result;
    }

    protected void onDeserializationStart(ValueType valueType, InputType input) throws Exception {
    }

    protected void onDeserializationEnd(ValueType valueType, InputType input) throws Exception {
    }

    protected abstract InputType adaptInput(InputStream var1) throws Exception;

    protected abstract Object readPlainValue(InputType var1) throws Exception;

    protected abstract <T> Collection<T> readArrayInCollection(InputType var1, Function<InputType, T> var2, Collection<T> var3) throws Exception;

    protected abstract <K, V> Map<K, V> readMapInMap(InputType var1, Function<InputType, K> var2, Function<InputType, V> var3, Map<K, V> var4) throws Exception;

    protected abstract InputNodeType readObjectTree(InputType var1) throws Exception;

    protected abstract Object asSimpleValue(InputNodeType var1) throws Exception;

    protected abstract boolean isObjectValue(InputNodeType var1) throws Exception;

    protected abstract boolean objectHasField(InputNodeType var1, String var2) throws Exception;

    protected abstract <T> T getObjectFieldValue(InputNodeType var1, String var2, Function<InputNodeType, T> var3) throws Exception;

    protected abstract <T> void putArrayNodeInCollection(InputNodeType var1, Function<InputNodeType, T> var2, Collection<T> var3) throws Exception;

    protected abstract <K, V> void putArrayNodeInMap(InputNodeType var1, Function<InputNodeType, K> var2, Function<InputNodeType, V> var3, Map<K, V> var4) throws Exception;

    protected abstract <V> void putObjectNodeInMap(InputNodeType var1, Function<InputNodeType, V> var2, Map<String, V> var3) throws Exception;

    public static interface ComplexDeserializer<T, InputType, InputNodeType> {
        public T deserializePull(InputType var1) throws Exception;

        public T deserializeTree(InputNodeType var1) throws Exception;
    }
}

