/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.valueserialization.orgjson;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueDeserializer;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.functional.Function;
import org.qi4j.spi.value.ValueDeserializerAdapter;

public class OrgJsonValueDeserializer
extends ValueDeserializerAdapter<JSONTokener, Object> {
    public OrgJsonValueDeserializer(@Structure Application application, @Structure Module module, @Service ServiceReference<ValueDeserializer> serviceRef) {
        super(application, module, serviceRef);
    }

    OrgJsonValueDeserializer(Application application, Module module, Function<Application, Module> valuesModuleFinder) {
        super(application, module, valuesModuleFinder);
    }

    @Override
    protected JSONTokener adaptInput(InputStream input) throws Exception {
        return new JSONTokener((Reader)new InputStreamReader(input, "UTF-8"));
    }

    @Override
    protected Object readPlainValue(JSONTokener input) throws Exception {
        Object nextValue = input.nextValue();
        if (JSONObject.NULL.equals(nextValue)) {
            return null;
        }
        if (JSONObject.class.isAssignableFrom(nextValue.getClass()) || JSONArray.class.isAssignableFrom(nextValue.getClass())) {
            throw new ValueSerializationException("Asked for a Value but found an Object or an Array.");
        }
        return nextValue;
    }

    @Override
    protected <T> Collection<T> readArrayInCollection(JSONTokener input, Function<JSONTokener, T> deserializer, Collection<T> collection) throws Exception {
        char c = input.nextClean();
        if (c == 'n') {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                sb.append(c);
                c = input.next();
            }
            input.back();
            String s = sb.toString().trim();
            if (!"null".equals(s)) {
                input.syntaxError("Unknown value: '" + s + "'");
            }
            return null;
        }
        if (c != '[') {
            throw input.syntaxError("A JSONArray text must start with '['");
        }
        char q = ']';
        if (input.nextClean() == ']') {
            return collection;
        }
        input.back();
        block5: while (true) {
            if (input.nextClean() == ',') {
                input.back();
                collection.add(null);
            } else {
                input.back();
                collection.add(deserializer.map((Object)input));
            }
            c = input.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    if (input.nextClean() == ']') {
                        return collection;
                    }
                    input.back();
                    continue block5;
                }
                case ')': 
                case ']': {
                    if (q != c) {
                        throw input.syntaxError("Expected a '" + Character.valueOf(q) + "'");
                    }
                    return collection;
                }
            }
            break;
        }
        throw input.syntaxError("Expected a ',' or ']'");
    }

    @Override
    protected <K, V> Map<K, V> readMapInMap(JSONTokener input, Function<JSONTokener, K> keyDeserializer, Function<JSONTokener, V> valueDeserializer, Map<K, V> map) throws Exception {
        char c = input.nextClean();
        if (c == 'n') {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                sb.append(c);
                c = input.next();
            }
            input.back();
            String s = sb.toString().trim();
            if (!"null".equals(s)) {
                input.syntaxError("Unknown value: '" + s + "'");
            }
            return null;
        }
        if (c != '[') {
            throw input.syntaxError("A JSONArray text must start with '['");
        }
        char q = ']';
        if (input.nextClean() == ']') {
            return map;
        }
        input.back();
        block13: while (true) {
            if (input.nextClean() == ',') {
                input.back();
            } else {
                input.back();
                if (input.nextClean() != '{') {
                    throw input.syntaxError("A JSONObject text must begin with '{'");
                }
                Object key = null;
                Object value = null;
                boolean breakIteration = false;
                block14: while (!breakIteration) {
                    c = input.nextClean();
                    switch (c) {
                        case '\u0000': {
                            throw input.syntaxError("A JSONObject text must end with '}'");
                        }
                        case '}': {
                            breakIteration = true;
                            continue block14;
                        }
                    }
                    input.back();
                    String objectKey = input.nextValue().toString();
                    c = input.nextClean();
                    if (c == '=') {
                        if (input.next() != '>') {
                            input.back();
                        }
                    } else if (c != ':') {
                        throw input.syntaxError("Expected a ':' after a key");
                    }
                    if ("key".equals(objectKey)) {
                        key = keyDeserializer.map((Object)input);
                    } else if ("value".equals(objectKey)) {
                        value = valueDeserializer.map((Object)input);
                    } else {
                        input.nextValue();
                    }
                    switch (input.nextClean()) {
                        case ',': 
                        case ';': {
                            if (input.nextClean() == '}') {
                                breakIteration = true;
                                continue block14;
                            }
                            input.back();
                            continue block14;
                        }
                        case '}': {
                            breakIteration = true;
                            continue block14;
                        }
                    }
                    throw input.syntaxError("Expected a ',' or '}'");
                }
                if (key != null) {
                    map.put(key, value);
                }
            }
            c = input.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    if (input.nextClean() == ']') {
                        return map;
                    }
                    input.back();
                    continue block13;
                }
                case ')': 
                case ']': {
                    if (q != c) {
                        throw input.syntaxError("Expected a '" + Character.valueOf(q) + "'");
                    }
                    return map;
                }
            }
            break;
        }
        throw input.syntaxError("Expected a ',' or ']'");
    }

    @Override
    protected JSONObject readObjectTree(JSONTokener input) throws Exception {
        Object objectTree = input.nextValue();
        if (JSONObject.NULL.equals(objectTree)) {
            return null;
        }
        return (JSONObject)objectTree;
    }

    @Override
    protected Object asSimpleValue(Object inputNode) throws Exception {
        if (JSONObject.NULL.equals(inputNode)) {
            return null;
        }
        if (inputNode instanceof JSONObject || inputNode instanceof JSONArray) {
            throw new ValueSerializationException("Expected a simple value but got " + inputNode);
        }
        return inputNode;
    }

    @Override
    protected boolean isObjectValue(Object inputNode) throws Exception {
        if (JSONObject.NULL.equals(inputNode)) {
            return false;
        }
        return inputNode instanceof JSONObject;
    }

    @Override
    protected boolean objectHasField(Object inputNode, String key) throws Exception {
        if (JSONObject.NULL.equals(inputNode)) {
            return false;
        }
        if (!(inputNode instanceof JSONObject)) {
            throw new ValueSerializationException("Expected an object but got " + inputNode);
        }
        JSONObject json = (JSONObject)inputNode;
        return json.has(key);
    }

    @Override
    protected <T> T getObjectFieldValue(Object inputNode, String key, Function<Object, T> valueDeserializer) throws Exception {
        JSONObject json = (JSONObject)inputNode;
        Object valueNode = json.opt(key);
        if (JSONObject.NULL.equals(valueNode)) {
            return null;
        }
        Object value = valueDeserializer.map(valueNode);
        return (T)value;
    }

    @Override
    protected <T> void putArrayNodeInCollection(Object inputNode, Function<Object, T> deserializer, Collection<T> collection) throws Exception {
        if (JSONObject.NULL.equals(inputNode)) {
            return;
        }
        if (!(inputNode instanceof JSONArray)) {
            throw new ValueSerializationException("Expected an array but got " + inputNode);
        }
        JSONArray array = (JSONArray)inputNode;
        for (int idx = 0; idx < array.length(); ++idx) {
            Object item = array.get(idx);
            Object value = deserializer.map(item);
            collection.add(value);
        }
    }

    @Override
    protected <K, V> void putArrayNodeInMap(Object inputNode, Function<Object, K> keyDeserializer, Function<Object, V> valueDeserializer, Map<K, V> map) throws Exception {
        if (JSONObject.NULL.equals(inputNode)) {
            return;
        }
        if (!(inputNode instanceof JSONArray)) {
            throw new ValueSerializationException("Expected an array but got " + inputNode);
        }
        JSONArray array = (JSONArray)inputNode;
        for (int idx = 0; idx < array.length(); ++idx) {
            Object item = array.get(idx);
            if (!(item instanceof JSONObject)) {
                throw new ValueSerializationException("Expected an object but got " + inputNode);
            }
            JSONObject object = (JSONObject)item;
            Object keyNode = object.get("key");
            Object valueNode = object.get("value");
            Object key = keyDeserializer.map(keyNode);
            Object value = valueDeserializer.map(valueNode);
            if (key == null) continue;
            map.put(key, value);
        }
    }

    @Override
    protected <V> void putObjectNodeInMap(Object inputNode, Function<Object, V> valueDeserializer, Map<String, V> map) throws Exception {
        if (JSONObject.NULL.equals(inputNode)) {
            return;
        }
        if (!(inputNode instanceof JSONObject)) {
            throw new ValueSerializationException("Expected an object but got " + inputNode);
        }
        JSONObject object = (JSONObject)inputNode;
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object item = object.get(key);
            Object valueValue = valueDeserializer.map(item);
            if (key == null) continue;
            map.put(key, valueValue);
        }
    }
}

