/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.valueserialization.orgjson;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.json.JSONWriter;
import org.qi4j.spi.value.ValueSerializerAdapter;

public class OrgJsonValueSerializer
extends ValueSerializerAdapter<OrgJsonOutput> {
    @Override
    protected OrgJsonOutput adaptOutput(OutputStream output) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
        JSONWriter json = new JSONWriter((Writer)writer);
        return new OrgJsonOutput(writer, json);
    }

    @Override
    protected void onSerializationEnd(Object object, OrgJsonOutput output) throws Exception {
        output.writer.flush();
    }

    @Override
    protected void onArrayStart(OrgJsonOutput output) throws Exception {
        output.json.array();
    }

    @Override
    protected void onArrayEnd(OrgJsonOutput output) throws Exception {
        output.json.endArray();
    }

    @Override
    protected void onObjectStart(OrgJsonOutput output) throws Exception {
        output.json.object();
    }

    @Override
    protected void onObjectEnd(OrgJsonOutput output) throws Exception {
        output.json.endObject();
    }

    @Override
    protected void onFieldStart(OrgJsonOutput output, String fieldName) throws Exception {
        output.json.key(fieldName);
    }

    @Override
    protected void onValue(OrgJsonOutput output, Object value) throws Exception {
        output.json.value(value);
    }

    public static class OrgJsonOutput {
        private final Writer writer;
        private final JSONWriter json;

        private OrgJsonOutput(Writer writer, JSONWriter json) {
            this.writer = writer;
            this.json = json;
        }
    }
}

