/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.api;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.Optional;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.constraint.Name;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.library.rest.common.Resource;
import org.qi4j.library.rest.common.link.Link;
import org.qi4j.library.rest.server.api.ContextRestlet;
import org.qi4j.library.rest.server.api.ObjectSelection;
import org.qi4j.library.rest.server.api.ResourceDelete;
import org.qi4j.library.rest.server.api.ResourceUpdate;
import org.qi4j.library.rest.server.api.ResourceValidity;
import org.qi4j.library.rest.server.api.SubResource;
import org.qi4j.library.rest.server.api.SubResources;
import org.qi4j.library.rest.server.restlet.ConstraintViolationMessages;
import org.qi4j.library.rest.server.restlet.InteractionConstraints;
import org.qi4j.library.rest.server.restlet.RequestReaderDelegator;
import org.qi4j.library.rest.server.restlet.ResponseWriterDelegator;
import org.qi4j.library.rest.server.spi.ResultConverter;
import org.qi4j.spi.Qi4jSPI;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import org.slf4j.LoggerFactory;

public class ContextResource
implements Uniform {
    private static final String ARGUMENTS = "arguments";
    public static final String RESOURCE_VALIDITY = "validity";
    @Structure
    protected Module module;
    private final Map<String, Method> resourceMethodQueries = new HashMap<String, Method>();
    private final Map<String, Method> resourceMethodCommands = new HashMap<String, Method>();
    private final Map<String, Method> subResources = new LinkedHashMap<String, Method>();
    private final List<Method> resourceQueries = new ArrayList<Method>();
    private final List<Method> resourceCommands = new ArrayList<Method>();
    @Structure
    private Qi4jSPI spi;
    @Service
    private ResponseWriterDelegator responseWriter;
    @Service
    private RequestReaderDelegator requestReader;
    @Service
    private InteractionConstraints constraints;
    @Optional
    @Service
    private ResultConverter converter;
    @Uses
    private ContextRestlet restlet;

    public ContextResource() {
        for (Method method : this.getClass().getMethods()) {
            Method oldMethod;
            if (!ContextResource.class.isAssignableFrom(method.getDeclaringClass()) || ContextResource.class.equals(method.getDeclaringClass()) || method.isSynthetic()) continue;
            if (method.getAnnotation(SubResource.class) == null) {
                if (this.isCommand(method)) {
                    oldMethod = this.resourceMethodCommands.put(method.getName().toLowerCase(), method);
                    this.resourceCommands.add(method);
                } else {
                    oldMethod = this.resourceMethodQueries.put(method.getName().toLowerCase(), method);
                    this.resourceQueries.add(method);
                }
                if (oldMethod == null) continue;
                throw new IllegalStateException("Two methods in resource " + this.getClass().getName() + " with same name " + oldMethod.getName() + ", which is not allowed");
            }
            oldMethod = this.subResources.put(method.getName().toLowerCase(), method);
            if (oldMethod == null) continue;
            throw new IllegalStateException("Two methods in resource " + this.getClass().getName() + " with same name " + oldMethod.getName() + ", which is not allowed");
        }
    }

    public final void handle(Request request, Response response) {
        ObjectSelection objectSelection = ObjectSelection.current();
        if (!this.constraints.isValid(this.getClass(), objectSelection, this.module)) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN);
        }
        List<String> segments = this.getSegments();
        if (segments.size() > 0) {
            String segment = segments.remove(0);
            if (segments.size() > 0) {
                this.handleSubResource(segment);
            } else {
                this.handleResource(segment);
            }
        }
    }

    protected void setResourceValidity(EntityComposite entity) {
        Request request = Request.getCurrent();
        ResourceValidity validity = new ResourceValidity(entity, this.spi, request);
        request.getAttributes().put(RESOURCE_VALIDITY, validity);
    }

    protected void subResource(Class<? extends ContextResource> subResourceClass) {
        this.restlet.subResource(subResourceClass);
    }

    protected <T> T select(Class<T> entityClass, String id) throws ResourceException {
        try {
            Object composite = this.module.currentUnitOfWork().get(entityClass, id);
            ObjectSelection.current().select(composite);
            return (T)composite;
        }
        catch (EntityTypeNotFoundException | NoSuchEntityException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    protected <T> T selectFromManyAssociation(ManyAssociation<T> manyAssociation, String id) throws ResourceException {
        Object entity = this.module.currentUnitOfWork().get(Object.class, id);
        if (!manyAssociation.contains(entity)) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        ObjectSelection.current().select(entity);
        return (T)entity;
    }

    protected <T> T selectFromNamedAssociation(NamedAssociation<T> namedAssociation, String id) throws ResourceException {
        Object entity = this.module.currentUnitOfWork().get(Object.class, id);
        String name = namedAssociation.nameOf(entity);
        if (name == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        ObjectSelection.current().select(entity);
        return (T)entity;
    }

    protected void selectFromList(List<?> list, String indexString) {
        Integer index = Integer.decode(indexString);
        if (index < 0 || index >= list.size()) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        ObjectSelection.current().select(index);
        Object value = list.get(index);
        ObjectSelection.current().select(value);
    }

    protected Locale getLocale() {
        Locale locale;
        Request request = Request.getCurrent();
        List preferenceList = request.getClientInfo().getAcceptedLanguages();
        if (preferenceList.isEmpty()) {
            return Locale.getDefault();
        }
        Language language = (Language)((Preference)preferenceList.get(0)).getMetadata();
        String[] localeStr = language.getName().split("-");
        switch (localeStr.length) {
            case 1: {
                locale = new Locale(localeStr[0]);
                break;
            }
            case 2: {
                locale = new Locale(localeStr[0], localeStr[1]);
                break;
            }
            case 3: {
                locale = new Locale(localeStr[0], localeStr[1], localeStr[2]);
                break;
            }
            default: {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    protected <T> T context(Class<T> contextClass) {
        return (T)this.module.newObject(contextClass, ObjectSelection.current().toArray());
    }

    private void handleSubResource(String segment) {
        if (this instanceof SubResources) {
            SubResources subResources = (SubResources)((Object)this);
            try {
                StringBuilder template = (StringBuilder)Request.getCurrent().getAttributes().get("template");
                template.append("resource/");
                subResources.resource(URLDecoder.decode(segment, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                subResources.resource(segment);
            }
        } else {
            try {
                Method method = this.getSubResourceMethod(segment);
                StringBuilder template = (StringBuilder)Request.getCurrent().getAttributes().get("template");
                template.append(segment).append("/");
                method.invoke((Object)this, new Object[0]);
            }
            catch (Throwable e) {
                this.handleException(Response.getCurrent(), e);
            }
        }
    }

    private Method getSubResourceMethod(String resourceName) throws ResourceException {
        Method method = this.subResources.get(resourceName);
        if (method != null) {
            return method;
        }
        throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
    }

    private void resource() {
        Request request = Request.getCurrent();
        Response response = Response.getCurrent();
        if (!request.getMethod().equals((Object)org.restlet.data.Method.GET)) {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            return;
        }
        ObjectSelection objectSelection = ObjectSelection.current();
        if (ResourceDelete.class.isAssignableFrom(this.getClass())) {
            response.getAllowedMethods().add(org.restlet.data.Method.DELETE);
        }
        if (ResourceUpdate.class.isAssignableFrom(this.getClass())) {
            response.getAllowedMethods().add(org.restlet.data.Method.PUT);
        }
        ValueBuilder builder = this.module.newValueBuilder(Resource.class);
        List queriesProperty = (List)((Resource)builder.prototype()).queries().get();
        for (Method query : this.resourceQueries) {
            if (!this.constraints.isValid(query, objectSelection, this.module)) continue;
            ValueBuilder linkBuilder = this.module.newValueBuilder(Link.class);
            Link prototype = (Link)linkBuilder.prototype();
            prototype.classes().set((Object)"query");
            prototype.text().set((Object)this.humanReadable(query.getName()));
            prototype.href().set((Object)query.getName().toLowerCase());
            prototype.rel().set((Object)query.getName().toLowerCase());
            prototype.id().set((Object)query.getName().toLowerCase());
            queriesProperty.add(linkBuilder.newInstance());
        }
        List commandsProperty = (List)((Resource)builder.prototype()).commands().get();
        for (Method command : this.resourceCommands) {
            if (!this.constraints.isValid(command, objectSelection, this.module)) continue;
            ValueBuilder linkBuilder = this.module.newValueBuilder(Link.class);
            Link prototype = (Link)linkBuilder.prototype();
            prototype.classes().set((Object)"command");
            prototype.text().set((Object)this.humanReadable(command.getName()));
            prototype.href().set((Object)command.getName().toLowerCase());
            prototype.rel().set((Object)command.getName().toLowerCase());
            prototype.id().set((Object)command.getName().toLowerCase());
            commandsProperty.add(linkBuilder.newInstance());
        }
        List resourcesProperty = (List)((Resource)builder.prototype()).resources().get();
        for (Method subResource : this.subResources.values()) {
            if (!this.constraints.isValid(subResource, objectSelection, this.module)) continue;
            ValueBuilder linkBuilder = this.module.newValueBuilder(Link.class);
            Link prototype = (Link)linkBuilder.prototype();
            prototype.classes().set((Object)"resource");
            prototype.text().set((Object)this.humanReadable(subResource.getName()));
            prototype.href().set((Object)(subResource.getName().toLowerCase() + "/"));
            prototype.rel().set((Object)subResource.getName().toLowerCase());
            prototype.id().set((Object)subResource.getName().toLowerCase());
            resourcesProperty.add(linkBuilder.newInstance());
        }
        try {
            Object index;
            Method indexMethod = this.resourceMethodQueries.get("index");
            if (indexMethod != null && (index = this.convert(indexMethod.invoke((Object)this, new Object[0]))) != null && index instanceof ValueComposite) {
                ((Resource)builder.prototype()).index().set((Object)((ValueComposite)index));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.responseWriter.writeResponse(builder.newInstance(), response);
        }
        catch (Throwable e) {
            this.handleException(response, e);
        }
    }

    private boolean isCommand(Method method) {
        return method.getReturnType().equals(Void.TYPE) || method.getName().equals("create");
    }

    private String humanReadable(String name) {
        StringBuilder humanReadableString = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (i == 0) {
                humanReadableString.append(Character.toUpperCase(character));
                continue;
            }
            if (Character.isLowerCase(character)) {
                humanReadableString.append(character);
                continue;
            }
            humanReadableString.append(' ').append(Character.toLowerCase(character));
        }
        return humanReadableString.toString();
    }

    private void result(Object resultValue) throws Exception {
        if (resultValue != null && !this.responseWriter.writeResponse(resultValue, Response.getCurrent())) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "No result writer for type " + resultValue.getClass().getName());
        }
    }

    private List<String> getSegments() {
        return (List)Request.getCurrent().getAttributes().get("segments");
    }

    private void handleResource(String segment) {
        Request request = Request.getCurrent();
        if (segment.isEmpty() || segment.equals(".")) {
            StringBuilder template = (StringBuilder)request.getAttributes().get("template");
            template.append("resource");
            this.resource();
        } else {
            StringBuilder template = (StringBuilder)request.getAttributes().get("template");
            template.append(segment);
            if (this.resourceMethodCommands.containsKey(segment)) {
                this.handleCommand(segment);
            } else {
                this.handleQuery(segment);
            }
        }
    }

    private void handleCommand(String segment) {
        block12: {
            Request request = Request.getCurrent();
            Response response = Response.getCurrent();
            Method interactionMethod = this.resourceMethodCommands.get(segment);
            if (this.shouldShowCommandForm(interactionMethod)) {
                response.getAllowedMethods().add(org.restlet.data.Method.POST);
                try {
                    Method queryMethod = this.resourceMethodQueries.get(segment);
                    if (queryMethod != null) {
                        this.result(queryMethod.invoke((Object)this, new Object[0]));
                        break block12;
                    }
                    request.setMethod(org.restlet.data.Method.POST);
                    response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
                    this.result(this.formForMethod(interactionMethod));
                }
                catch (Exception e) {
                    this.handleException(response, e);
                }
            } else {
                ResourceValidity validity = (ResourceValidity)request.getAttributes().get(RESOURCE_VALIDITY);
                if (validity != null) {
                    validity.checkRequest();
                }
                if (!this.constraints.isValid(interactionMethod, ObjectSelection.current(), this.module)) {
                    throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
                }
                Object[] arguments = this.requestReader.readRequest(Request.getCurrent(), interactionMethod);
                Request.getCurrent().getAttributes().put(ARGUMENTS, arguments);
                try {
                    Object result = interactionMethod.invoke((Object)this, arguments);
                    if (result != null) {
                        if (result instanceof Representation) {
                            response.setEntity((Representation)result);
                        } else {
                            this.result(this.convert(result));
                        }
                    }
                }
                catch (Throwable e) {
                    this.handleException(response, e);
                }
            }
        }
    }

    private boolean shouldShowCommandForm(Method interactionMethod) {
        if (Request.getCurrent().getMethod().isSafe()) {
            return true;
        }
        if (interactionMethod.getParameterTypes().length > 0) {
            return !interactionMethod.getParameterTypes()[0].equals(Response.class) && !Request.getCurrent().getEntity().isAvailable() && Request.getCurrent().getEntityAsText() == null && Request.getCurrent().getResourceRef().getQuery() == null;
        }
        return false;
    }

    private void handleQuery(String segment) {
        Request request = Request.getCurrent();
        Response response = Response.getCurrent();
        Method queryMethod = this.resourceMethodQueries.get(segment);
        if (queryMethod == null) {
            queryMethod = this.resourceMethodCommands.get(segment);
        }
        if (queryMethod == null) {
            Method resourceMethod = this.subResources.get(segment);
            if (resourceMethod != null && resourceMethod.getAnnotation(SubResource.class) != null) {
                response.setStatus(Status.REDIRECTION_FOUND);
                response.setLocationRef(new Reference(request.getResourceRef().toString() + "/").toString());
                return;
            }
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (request.getMethod().isSafe() && queryMethod.getParameterTypes().length != 0 && request.getResourceRef().getQuery() == null || !request.getMethod().isSafe() && queryMethod.getParameterTypes().length != 0 && !request.getEntity().isAvailable() && request.getResourceRef().getQuery() == null && !queryMethod.getParameterTypes()[0].equals(Response.class)) {
            try {
                response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
                response.getAllowedMethods().add(org.restlet.data.Method.GET);
                response.getAllowedMethods().add(org.restlet.data.Method.POST);
                this.result(this.formForMethod(queryMethod));
            }
            catch (Exception e) {
                this.handleException(response, e);
            }
        } else {
            ResourceValidity validity = (ResourceValidity)request.getAttributes().get(RESOURCE_VALIDITY);
            if (validity != null) {
                validity.checkRequest();
            }
            if (!this.constraints.isValid(queryMethod, ObjectSelection.current(), this.module)) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
            }
            try {
                Object[] arguments;
                block18: {
                    if (queryMethod.getParameterTypes().length > 0) {
                        try {
                            arguments = this.requestReader.readRequest(Request.getCurrent(), queryMethod);
                            if (arguments == null) {
                                this.result(this.formForMethod(queryMethod));
                                return;
                            }
                            break block18;
                        }
                        catch (IllegalArgumentException e) {
                            this.result(this.formForMethod(queryMethod));
                            return;
                        }
                    }
                    arguments = new Object[]{};
                }
                Request.getCurrent().getAttributes().put(ARGUMENTS, arguments);
                Object result = queryMethod.invoke((Object)this, arguments);
                if (result != null) {
                    if (result instanceof Representation) {
                        response.setEntity((Representation)result);
                    } else {
                        this.result(this.convert(result));
                    }
                }
            }
            catch (Throwable e) {
                this.handleException(response, e);
            }
        }
    }

    private Object convert(Object result) {
        if (this.converter != null) {
            result = this.converter.convert(result, Request.getCurrent(), (Object[])Request.getCurrent().getAttributes().get(ARGUMENTS));
        }
        return result;
    }

    private void handleException(Response response, Throwable ex) {
        while (ex instanceof InvocationTargetException) {
            ex = ex.getCause();
        }
        try {
            throw ex;
        }
        catch (ResourceException e) {
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(e.getStatus());
        }
        catch (ConstraintViolationException e) {
            try {
                ConstraintViolationMessages cvm = new ConstraintViolationMessages();
                String messages = "";
                Locale locale = ObjectSelection.type(Locale.class);
                for (ConstraintViolation constraintViolation : e.constraintViolations()) {
                    if (!messages.isEmpty()) {
                        messages = messages + "\n";
                    }
                    messages = messages + cvm.getMessage(constraintViolation, locale);
                }
                response.setEntity((Representation)new StringRepresentation((CharSequence)messages));
                response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
            }
            catch (Exception e1) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
                response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
            }
        }
        catch (IllegalArgumentException e) {
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception thrown during processing", (Throwable)e);
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
        }
        catch (Exception e) {
            String s = e.getMessage();
            if (s == null) {
                s = e.getClass().getSimpleName();
            }
            response.setEntity((Representation)new StringRepresentation((CharSequence)s));
            response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception thrown during processing", e);
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Form formForMethod(Method interactionMethod) {
        Form form = new Form();
        Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm();
        Representation representation = Request.getCurrent().getEntity();
        Form entityAsForm = representation != null && !EmptyRepresentation.class.isInstance(representation) ? new Form(representation) : new Form();
        Class<?> valueType = interactionMethod.getParameterTypes()[0];
        if (ValueComposite.class.isAssignableFrom(valueType)) {
            ValueDescriptor valueDescriptor = this.module.valueDescriptor(valueType.getName());
            for (PropertyDescriptor propertyDescriptor : valueDescriptor.state().properties()) {
                void var10_13;
                Object initialValue;
                String string = this.getValue(propertyDescriptor.qualifiedName().name(), queryAsForm, entityAsForm);
                if (string == null && (initialValue = propertyDescriptor.initialValue(this.module)) != null) {
                    String string2 = initialValue.toString();
                }
                form.add(propertyDescriptor.qualifiedName().name(), (String)var10_13);
            }
        } else if (valueType.isInterface() && interactionMethod.getParameterTypes().length == 1) {
            form.add("entity", this.getValue("entity", queryAsForm, entityAsForm));
        } else {
            for (Object[] objectArray : interactionMethod.getParameterAnnotations()) {
                Name name = (Name)Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Name.class), (Iterable)Iterables.iterable((Object[])objectArray)));
                form.add(name.value(), this.getValue(name.value(), queryAsForm, entityAsForm));
            }
        }
        return form;
    }

    private String getValue(String name, Form queryAsForm, Form entityAsForm) {
        String value = queryAsForm.getFirstValue(name);
        if (value == null) {
            value = entityAsForm.getFirstValue(name);
        }
        return value;
    }
}

