/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.common.AppliesToFilter;
import org.qi4j.api.concern.GenericConcern;
import org.qi4j.api.constraint.ConstraintDeclaration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.structure.Module;
import org.qi4j.library.rest.server.api.ObjectSelection;
import org.qi4j.library.rest.server.api.constraint.InteractionConstraintDeclaration;
import org.qi4j.library.rest.server.api.constraint.RequiresValid;
import org.qi4j.library.rest.server.restlet.InteractionConstraints;

@AppliesTo(value={HasInteractionConstraints.class})
public class InteractionConstraintsConcern
extends GenericConcern {
    @Service
    private InteractionConstraints interactionConstraints;
    @Service
    private Module module;

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.interactionConstraints.isValid(proxy.getClass(), ObjectSelection.current(), this.module)) {
            throw new IllegalStateException("Not allowed to invoke interaction " + method.getName());
        }
        if (!this.interactionConstraints.isValid(method, ObjectSelection.current(), this.module)) {
            throw new IllegalStateException("Not allowed to invoke interaction " + method.getName());
        }
        return ((InvocationHandler)this.next).invoke(proxy, method, args);
    }

    public static class HasInteractionConstraints
    implements AppliesToFilter {
        public boolean appliesTo(Method method, Class<?> mixin, Class<?> compositeType, Class<?> fragmentClass) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().equals(RequiresValid.class) && annotation.annotationType().getAnnotation(ConstraintDeclaration.class) == null && annotation.annotationType().getAnnotation(InteractionConstraintDeclaration.class) == null) continue;
                return true;
            }
            return false;
        }
    }
}

