/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.InitializationException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Module;
import org.qi4j.library.rest.server.spi.RequestReader;
import org.restlet.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReaderDelegator
implements RequestReader {
    private static final Object[] NULL_PARAMS = new Object[0];
    List<RequestReader> requestReaders = new ArrayList<RequestReader>();
    @Structure
    Module module;

    public void init(@Service Iterable<ServiceReference<RequestReader>> requestReaderReferences) throws InitializationException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        for (ServiceReference<RequestReader> requestReader : requestReaderReferences) {
            if (requestReader.identity().equals("requestreaderdelegator")) continue;
            logger.info("Registered request reader:" + requestReader.identity());
            this.registerRequestReader((RequestReader)requestReader.get());
        }
        ResourceBundle defaultRequestReaders = ResourceBundle.getBundle("org.qi4j.library.rest.server.rest-server");
        String requestReaderClasses = defaultRequestReaders.getString("requestreaders");
        logger.info("Using request readers:" + requestReaderClasses);
        for (String className : requestReaderClasses.split(",")) {
            try {
                Class<?> readerClass = this.module.classLoader().loadClass(className.trim());
                RequestReader writer = (RequestReader)this.module.newObject(readerClass, new Object[0]);
                this.registerRequestReader(writer);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not register request reader " + className, (Throwable)e);
            }
        }
    }

    public void registerRequestReader(RequestReader reader) {
        this.requestReaders.add(reader);
    }

    @Override
    public Object[] readRequest(Request request, Method method) {
        if (method.getParameterTypes().length == 0) {
            return NULL_PARAMS;
        }
        for (RequestReader requestReader : this.requestReaders) {
            Object[] arguments = requestReader.readRequest(request, method);
            if (arguments == null) continue;
            return arguments;
        }
        return null;
    }
}

