/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;

public class JSONResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);

    @Override
    public boolean writeResponse(Object result, Response response) throws ResourceException {
        if (result instanceof JSONObject) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                JSONObject json = (JSONObject)result;
                StringRepresentation representation = new StringRepresentation((CharSequence)json.toString(), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                JSONObject json = (JSONObject)result;
                StringRepresentation representation = new StringRepresentation((CharSequence)json.toString(), MediaType.TEXT_HTML);
                response.setEntity((Representation)representation);
                return true;
            }
        }
        return false;
    }
}

