/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.library.rest.common.link.Link;
import org.qi4j.library.rest.common.link.Links;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class LinksResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedLinkMediaTypes = Arrays.asList(MediaType.APPLICATION_JSON);
    private static final List<MediaType> supportedLinksMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_ATOM);
    @Service
    Configuration cfg;

    @Override
    public boolean writeResponse(Object result, Response response) throws ResourceException {
        if (result instanceof Link) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedLinkMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)((Link)result).toString(), MediaType.APPLICATION_JSON));
                return true;
            }
            response.setStatus(Status.REDIRECTION_TEMPORARY);
            Link link = (Link)result;
            Reference reference = new Reference(response.getRequest().getResourceRef(), (String)link.href().get());
            response.setLocationRef(reference);
            return true;
        }
        if (result instanceof Links) {
            StringRepresentation rep;
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedLinksMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                rep = this.createJsonRepresentation((Links)result);
            } else if (MediaType.TEXT_HTML.equals((Object)type)) {
                rep = this.createTextHtmlRepresentation(result, response);
            } else if (MediaType.APPLICATION_ATOM.equals((Object)type)) {
                rep = this.createAtomRepresentation(result, response);
            } else {
                return false;
            }
            response.setEntity((Representation)rep);
            return true;
        }
        return false;
    }

    private StringRepresentation createJsonRepresentation(Links result) {
        return new StringRepresentation((CharSequence)result.toString(), MediaType.APPLICATION_JSON);
    }

    private Representation createTextHtmlRepresentation(final Object result, final Response response) {
        return new WriterRepresentation(MediaType.TEXT_HTML){

            public void write(Writer writer) throws IOException {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("request", response.getRequest());
                context.put("response", response);
                context.put("result", result);
                try {
                    LinksResponseWriter.this.cfg.getTemplate("links.htm").process(context, writer);
                }
                catch (TemplateException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private Representation createAtomRepresentation(final Object result, final Response response) {
        return new WriterRepresentation(MediaType.APPLICATION_ATOM){

            public void write(Writer writer) throws IOException {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("request", response.getRequest());
                context.put("response", response);
                context.put("result", result);
                try {
                    LinksResponseWriter.this.cfg.getTemplate("links.atom").process(context, writer);
                }
                catch (TemplateException e) {
                    throw new IOException(e);
                }
            }
        };
    }
}

