/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.service.MetadataService;

public class ResourceTemplateResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ATOM);
    @Service
    private Configuration cfg;
    @Service
    private MetadataService metadataService;
    Set<String> skip = new HashSet<String>();

    @Override
    public boolean writeResponse(final Object result, final Response response) throws ResourceException {
        MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
        if (type != null) {
            StringBuilder templateBuilder = (StringBuilder)response.getRequest().getAttributes().get("template");
            String templateName = templateBuilder.toString();
            if (result instanceof ValueDescriptor) {
                templateName = templateName + "_form";
            }
            String extension = this.metadataService.getExtension((Metadata)type);
            if (this.skip.contains(templateName = templateName + "." + extension)) {
                return false;
            }
            try {
                final Template template = this.cfg.getTemplate(templateName);
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("request", response.getRequest());
                        context.put("response", response);
                        context.put("result", result);
                        try {
                            template.process(context, writer);
                        }
                        catch (TemplateException e) {
                            throw new IOException(e);
                        }
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
            catch (Exception e) {
                this.skip.add(templateName);
            }
        }
        return false;
    }
}

