/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.util.Dates;
import org.qi4j.library.rest.common.table.Cell;
import org.qi4j.library.rest.common.table.Column;
import org.qi4j.library.rest.common.table.Row;
import org.qi4j.library.rest.common.table.Table;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class TableResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    @Service
    private Configuration cfg;

    @Override
    public boolean writeResponse(final Object result, final Response response) throws ResourceException {
        if (result instanceof Table) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                response.setEntity((Representation)new WriterRepresentation(MediaType.APPLICATION_JSON){

                    public void write(Writer writer) throws IOException {
                        try {
                            JSONWriter json = new JSONWriter(writer);
                            Table tableValue = (Table)result;
                            String tqx = response.getRequest().getResourceRef().getQueryAsForm().getFirstValue("tqx");
                            String reqId = null;
                            if (tqx != null) {
                                String[] params;
                                for (String param : params = tqx.split(";")) {
                                    String[] p = param.split(":");
                                    String key = p[0];
                                    String value = p[1];
                                    if (!key.equals("reqId")) continue;
                                    reqId = value;
                                }
                            }
                            json.object().key("version").value((Object)"0.6");
                            if (reqId != null) {
                                json.key("reqId").value(reqId);
                            }
                            json.key("status").value((Object)"ok");
                            json.key("table").object();
                            List columnList = (List)tableValue.cols().get();
                            json.key("cols").array();
                            for (Column columnValue : columnList) {
                                json.object().key("id").value(columnValue.id().get()).key("label").value(columnValue.label().get()).key("type").value(columnValue.columnType().get()).endObject();
                            }
                            json.endArray();
                            json.key("rows").array();
                            for (Row rowValue : (List)tableValue.rows().get()) {
                                json.object();
                                json.key("c").array();
                                int idx = 0;
                                for (Cell cellValue : (List)rowValue.c().get()) {
                                    json.object();
                                    Object value = cellValue.v().get();
                                    if (((String)((Column)columnList.get(idx)).columnType().get()).equals("datetime") && value != null) {
                                        value = Dates.toUtcString((Date)((Date)value));
                                    } else if (((String)((Column)columnList.get(idx)).columnType().get()).equals("date") && value != null) {
                                        value = new SimpleDateFormat("yyyy-MM-dd").format((Date)value);
                                    } else if (((String)((Column)columnList.get(idx)).columnType().get()).equals("timeofday") && value != null) {
                                        value = new SimpleDateFormat("HH:mm:ss").format((Date)value);
                                    }
                                    if (value != null) {
                                        json.key("v").value(value);
                                    }
                                    if (cellValue.f().get() != null) {
                                        json.key("f").value(cellValue.f().get());
                                    }
                                    json.endObject();
                                    ++idx;
                                }
                                json.endArray();
                                json.endObject();
                            }
                            json.endArray();
                            json.endObject();
                            json.endObject();
                        }
                        catch (JSONException e) {
                            throw new IOException(e);
                        }
                    }
                });
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("request", response.getRequest());
                        context.put("response", response);
                        context.put("result", result);
                        try {
                            TableResponseWriter.this.cfg.getTemplate("table.htm").process(context, writer);
                        }
                        catch (TemplateException e) {
                            throw new IOException(e);
                        }
                    }
                };
                rep.setCharacterSet(CharacterSet.UTF_8);
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

