/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.server.restlet.responsewriter;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.library.rest.server.restlet.responsewriter.AbstractResponseWriter;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class ValueDescriptorResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    @Structure
    private Module module;
    @Service
    private Configuration cfg;

    @Override
    public boolean writeResponse(final Object result, final Response response) throws ResourceException {
        if (result instanceof ValueDescriptor) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                JSONObject json = new JSONObject();
                ValueDescriptor vd = (ValueDescriptor)result;
                try {
                    for (PropertyDescriptor propertyDescriptor : vd.state().properties()) {
                        Object o = propertyDescriptor.initialValue(this.module);
                        if (o == null) {
                            json.put(propertyDescriptor.qualifiedName().name(), JSONObject.NULL);
                            continue;
                        }
                        json.put(propertyDescriptor.qualifiedName().name(), (Object)o.toString());
                    }
                }
                catch (JSONException e) {
                    throw new ResourceException((Throwable)e);
                }
                StringRepresentation representation = new StringRepresentation((CharSequence)json.toString(), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("request", response.getRequest());
                        context.put("response", response);
                        context.put("result", result);
                        try {
                            ValueDescriptorResponseWriter.this.cfg.getTemplate("form.htm").process(context, writer);
                        }
                        catch (TemplateException e) {
                            throw new IOException(e);
                        }
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

